package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ReferenceType;

/**
 * Created by covers1624 on 18/7/21.
 */
public final class LdcClass extends LdcInsn {

    private final ReferenceType type;
    private final ParameterizedClass resultType;

    public LdcClass(ReferenceType type, ParameterizedClass resultType) {
        this.type = type;
        this.resultType = resultType;
    }

    @Override
    public AType getResultType() {
        return resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcClass(this, ctx);
    }

    @Override
    public LdcClass copy() {
        return new LdcClass(type, resultType);
    }

    @Override
    public Object getRawValue() {
        return type;
    }

    public ReferenceType getType() {
        return type;
    }
}
