/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.javac.node;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.ClassProcessor;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.debug.NullStepper;
import net.covers1624.coffeegrinder.source.JavaSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.testengine.common.node.ChildDescriptor;
import net.covers1624.coffeegrinder.testengine.javac.JavacTestCaseInstanceContext;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.jvm.JVMUtils;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import net.covers1624.quack.io.IOUtils;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompileClassesNode
extends ChildDescriptor<JavacTestCaseInstanceContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecompileClassesNode.class);

    public DecompileClassesNode(UniqueId parentId) {
        super(parentId.append("name", "DecompileClasses"), "DecompileClasses");
    }

    public JavacTestCaseInstanceContext execute(JavacTestCaseInstanceContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ClassResolver classResolver = new ClassResolver();
        classResolver.addResolvers((Iterable)JVMUtils.getRuntimeJREClasspath());
        classResolver.setTarget(context.initialCompileOutput);
        TypeResolver typeResolver = new TypeResolver(classResolver);
        DecompilerSettings settings = new DecompilerSettings();
        Resolver resolver = classResolver.getTargetResolver();
        LinkedList classes = resolver.getAllClasses().toLinkedList();
        for (String clazz : classes) {
            LOGGER.info("Processing: {}", (Object)clazz);
            ClassType iClass = typeResolver.resolveClassDecl(clazz);
            if (iClass.getEnclosingClass().isPresent()) continue;
            ClassProcessor processor = new ClassProcessor(typeResolver, iClass, settings);
            ClassDecl decl = processor.process(NullStepper.INSTANCE);
            LineBuffer lines = (LineBuffer)decl.accept((InsnVisitor)new JavaSourceVisitor(typeResolver));
            Path output = context.outputSource.resolve(clazz + ".java");
            Files.write(IOUtils.makeParents((Path)output), String.join((CharSequence)"\n", lines.lines).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return context;
    }
}

