/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Compare;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.Continue;
import net.covers1624.coffeegrinder.bytecode.insns.DeadCode;
import net.covers1624.coffeegrinder.bytecode.insns.DoWhileLoop;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.LdcChar;
import net.covers1624.coffeegrinder.bytecode.insns.LdcClass;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodReference;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.NewObject;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.PostIncrement;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.Synchronized;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import net.covers1624.coffeegrinder.source.AbstractSourceVisitor;
import net.covers1624.coffeegrinder.source.EscapeUtils;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ParameterizedMethod;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class AstSourceVisitor
extends AbstractSourceVisitor {
    private static final Map<Class<?>, String> AST_NAMES = new ConcurrentHashMap();
    private final DebugPrintOptions opts;

    public AstSourceVisitor(DebugPrintOptions opts) {
        super(null);
        this.opts = opts;
    }

    @Override
    protected boolean showImplicits() {
        return this.opts.showImplicits();
    }

    private LineBuffer braced(Supplier<LineBuffer> body) {
        LineBuffer buffer = LineBuffer.of("{");
        this.pushIndent();
        buffer = buffer.join(this.indent(body.get()));
        this.popIndent();
        return buffer.add("}");
    }

    private LineBuffer header(Instruction insn) {
        return this.header(insn, true);
    }

    private LineBuffer header(Instruction insn, boolean printRange) {
        return LineBuffer.of().append(this.opts.printRanges() && printRange ? this.range(insn).append(" ") : LineBuffer.of()).append(this.opts.printTags() && insn.getTag() != null ? "[" + insn.getTag().describe() + "] " : "").append(this.name(insn));
    }

    private String name(Instruction insn) {
        Instruction instruction = insn;
        Objects.requireNonNull(instruction);
        Instruction instruction2 = instruction;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalReference.class, ArrayElementReference.class, FieldReference.class, TryCatch.TryCatchHandler.class, IfInstruction.class, Cast.class, DoWhileLoop.class}, (Object)instruction2, n)) {
            case 0 -> {
                LocalReference ignored = (LocalReference)instruction2;
                yield "LOCAL";
            }
            case 1 -> {
                ArrayElementReference ignored = (ArrayElementReference)instruction2;
                yield "ELEM";
            }
            case 2 -> {
                FieldReference ignored = (FieldReference)instruction2;
                yield "FIELD";
            }
            case 3 -> {
                TryCatch.TryCatchHandler ignored = (TryCatch.TryCatchHandler)instruction2;
                yield "CATCH";
            }
            case 4 -> {
                IfInstruction ignored = (IfInstruction)instruction2;
                yield "IF";
            }
            case 5 -> {
                Cast ignored = (Cast)instruction2;
                yield "CHECK_CAST";
            }
            case 6 -> {
                DoWhileLoop ignored = (DoWhileLoop)instruction2;
                yield "DO_WHILE";
            }
            default -> AST_NAMES.computeIfAbsent(insn.getClass(), AstSourceVisitor::computeName);
        };
    }

    private static String computeName(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        for (char c : clazz.getSimpleName().toCharArray()) {
            if (!sb.isEmpty() && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    private LineBuffer range(Instruction insn) {
        int offset = insn.getBytecodeOffset();
        return LineBuffer.of(offset == -1 ? "[?]" : "[" + offset + "]");
    }

    public List<String> getImports(@Nullable ClassDecl ctx) {
        return this.importCollector.getImports(ctx);
    }

    private LineBuffer typeQualifier(ClassType type, boolean mustPrint) {
        if (!mustPrint && !this.opts.qualifiedMemberReferences()) {
            return LineBuffer.of();
        }
        return LineBuffer.of(this.importCollector.collect(type)).append(".");
    }

    protected LineBuffer optionalArg(Instruction arg) {
        if (arg instanceof Nop) {
            return LineBuffer.of();
        }
        return LineBuffer.of(" ").append(this.argList(arg));
    }

    private LineBuffer typeParamDecl(List<TypeParameter> params, boolean padEnd) {
        if (params.isEmpty()) {
            return LineBuffer.of();
        }
        return LineBuffer.of("<").append(FastStream.of(params).map(this.importCollector::collectSimpleTypeParam).join(", ")).append(">").append(padEnd ? " " : "");
    }

    private LineBuffer parameterize(Method method, boolean explicit) {
        List<ReferenceType> typeArguments;
        if (method instanceof ParameterizedMethod && !(typeArguments = ((ParameterizedMethod)method).getTypeArguments()).isEmpty()) {
            return this.parameterize(typeArguments, explicit);
        }
        if (method.hasTypeParameters()) {
            return LineBuffer.of("<???>");
        }
        return LineBuffer.of();
    }

    private LineBuffer parameterize(ClassType clazz, boolean explicit) {
        if (clazz instanceof ParameterizedClass) {
            List<ReferenceType> typeArguments = ((ParameterizedClass)clazz).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                return this.parameterize(typeArguments, explicit);
            }
        } else if (clazz.hasTypeParameters()) {
            return LineBuffer.of("<???>");
        }
        return LineBuffer.of();
    }

    private LineBuffer parameterize(List<ReferenceType> typeArguments, boolean explicit) {
        LineBuffer buffer = LineBuffer.of();
        if (!typeArguments.isEmpty()) {
            if (this.opts.showImplicits() || explicit) {
                if (!explicit) {
                    buffer = buffer.append("~");
                }
                buffer = buffer.append("<");
                for (int i = 0; i < typeArguments.size(); ++i) {
                    ReferenceType arg = typeArguments.get(i);
                    if (i > 0) {
                        buffer = buffer.append(", ");
                    }
                    buffer = buffer.append(this.importCollector.collect(arg));
                }
                buffer = buffer.append(">");
            } else {
                buffer = buffer.append("<>");
            }
        }
        return buffer;
    }

    @Override
    public LineBuffer visitDefault(Instruction insn, None ctx) {
        return this.printDefault(insn);
    }

    private LineBuffer printDefault(Instruction insn) {
        return this.printDefault(insn, null);
    }

    private LineBuffer printDefault(Instruction insn, @Nullable Object extra) {
        boolean hasChildren = insn.getFirstChildOrNull() != null;
        return this.header(insn).append(extra != null ? "." + String.valueOf(extra) : "").append(hasChildren ? LineBuffer.of(" ").append(this.argList(insn.getChildren())) : LineBuffer.of());
    }

    @Override
    public LineBuffer visitNop(Nop nop, None ctx) {
        return this.header(nop, false);
    }

    @Override
    public LineBuffer visitDeadCode(DeadCode deadCode, None ctx) {
        return this.header(deadCode).append(" ").append(this.argList(deadCode.getCode()));
    }

    @Override
    public LineBuffer visitArrayElementReference(ArrayElementReference elemRef, None ctx) {
        return this.printDefault(elemRef);
    }

    @Override
    public LineBuffer visitBinary(Binary binary, None ctx) {
        return this.printDefault(binary, (Object)binary.getOp());
    }

    @Override
    public LineBuffer visitBlock(Block block, None ctx) {
        return this.header(block).append(" ").append(block.getName()).append(block.getParentOrNull() instanceof BlockContainer ? " (incoming: " + block.getIncomingEdgeCount() + ")" : "").append(" ").append(this.braced(() -> this.visitBlockBody(block)));
    }

    private LineBuffer visitBlockBody(Block block) {
        LineBuffer buffer = LineBuffer.of();
        Iterator<Instruction> iterator = block.instructions.iterator();
        while (iterator.hasNext()) {
            Instruction insn = iterator.next();
            if (this.opts.printLineNumbers()) {
                buffer = buffer.add("# LN: " + insn.getSourceLine());
            }
            buffer = buffer.join(this.lines(insn));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitBlockContainer(BlockContainer container, None ctx) {
        return this.header(container).append(" ").append(this.braced(() -> this.visitContainerBlocks(container)));
    }

    private LineBuffer visitContainerBlocks(BlockContainer container) {
        LineBuffer buffer = LineBuffer.of();
        boolean first = true;
        Iterator<Block> iterator = container.blocks.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!first) {
                buffer = buffer.add("");
            }
            first = false;
            buffer = buffer.join(this.lines(block));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitBranch(Branch branch, None ctx) {
        return this.printDefault(branch).append(" ").append(branch.getTargetBlock().getName());
    }

    @Override
    public LineBuffer visitCheckCast(Cast cast, None ctx) {
        return this.header(cast).append(" " + this.importCollector.collect(cast.getType())).append(this.argList(cast.getArgument()));
    }

    @Override
    public LineBuffer visitClassDecl(ClassDecl classDecl, None ctx) {
        return this.header(classDecl, false).append(" ").append(!(classDecl.getParentOrNull() instanceof New) ? this.printClassHeader(classDecl) : LineBuffer.of()).append(this.braced(() -> this.visitClassMembers(classDecl)));
    }

    private LineBuffer printClassHeader(ClassDecl classDecl) {
        ClassType clazz = classDecl.getClazz();
        return LineBuffer.of(AccessFlag.stringRep(clazz.getAccessFlags())).append(clazz.getName()).append(this.typeParamDecl(clazz.getTypeParameters(), false)).append(this.visitSuperClass(clazz)).append(this.visitInterfaces(clazz)).append(" ");
    }

    private LineBuffer visitSuperClass(ClassType type) {
        if (TypeSystem.isObject(type.getSuperClass())) {
            return LineBuffer.of();
        }
        return LineBuffer.of(" extends ").append(this.importCollector.collect(type.getSuperClass()));
    }

    private LineBuffer visitInterfaces(ClassType type) {
        List<ClassType> iFaces = type.getInterfaces();
        if (iFaces.isEmpty()) {
            return LineBuffer.of();
        }
        LineBuffer buffer = LineBuffer.of();
        buffer = type.isInterface() ? buffer.append(" extends ") : buffer.append(" implements ");
        return buffer.append(FastStream.of(iFaces).map(this.importCollector::collect).join(", "));
    }

    private LineBuffer visitClassMembers(ClassDecl decl) {
        LineBuffer buffer = LineBuffer.of();
        Iterator<Instruction> iterator = decl.members.iterator();
        while (iterator.hasNext()) {
            Instruction field = iterator.next();
            buffer = buffer.add("").join(this.lines(field));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitCompare(Compare compare, None ctx) {
        return this.printDefault(compare, (Object)compare.getKind());
    }

    @Override
    public LineBuffer visitComparison(Comparison comparison, None ctx) {
        return this.printDefault(comparison, (Object)comparison.getKind());
    }

    @Override
    public LineBuffer visitCompoundAssignment(CompoundAssignment comp, None ctx) {
        return this.printDefault(comp, (Object)comp.getOp());
    }

    @Override
    public LineBuffer visitContinue(Continue cont, None ctx) {
        return this.printDefault(cont).append(" ").append(cont.getLoop().getBody().getEntryPoint().getName());
    }

    @Override
    public LineBuffer visitDoWhileLoop(DoWhileLoop doWhileLoop, None ctx) {
        return this.header(doWhileLoop).append(" ").append(this.lines(doWhileLoop.getBody())).append(" ").append(this.argList(doWhileLoop.getCondition()));
    }

    @Override
    public LineBuffer visitFieldDecl(FieldDecl fieldDecl, None ctx) {
        Field field = fieldDecl.getField();
        return this.header(fieldDecl, false).append(" ").append(AccessFlag.toString(field.getAccessFlags())).append(this.importCollector.collect(field.getType())).append(" ").append(field.getName()).append(this.optionalArg(fieldDecl.getValue()));
    }

    @Override
    public LineBuffer visitFieldReference(FieldReference fieldRef, None ctx) {
        Field field = fieldRef.getField();
        return this.header(fieldRef, false).append(this.optionalArg(fieldRef.getTarget())).append(" ").append(this.typeQualifier(field.getDeclaringClass(), field.isStatic())).append(field.getName());
    }

    @Override
    public LineBuffer visitForEachLoop(ForEachLoop forEachLoop, None ctx) {
        return this.header(forEachLoop).append(" ").append(this.argList(forEachLoop.getVariable(), forEachLoop.getIterator())).append(" ").append(this.lines(forEachLoop.getBody()));
    }

    @Override
    public LineBuffer visitForLoop(ForLoop forLoop, None ctx) {
        return this.header(forLoop).append(" ").append(this.argList(forLoop.getInitializer(), forLoop.getCondition(), forLoop.getIncrement())).append(" ").append(this.lines(forLoop.getBody()));
    }

    @Override
    public LineBuffer visitIfInstruction(IfInstruction ifInsn, None ctx) {
        LineBuffer buffer = this.header(ifInsn).append(" ").append(this.argList(ifInsn.getCondition())).append(" ").append(this.lines(ifInsn.getTrueInsn()));
        if (!(ifInsn.getFalseInsn() instanceof Nop)) {
            buffer = buffer.add("ELSE ").append(this.lines(ifInsn.getFalseInsn()));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitLocalVariable(LocalVariable lv, None ctx) {
        return LineBuffer.of(lv.getKind().name()).append(" ").append(lv.getUniqueName()).append(" : ").append(this.importCollector.collect(lv.getType())).append("(").append(lv.getKind() != LocalVariable.VariableKind.STACK_SLOT ? "Index=" + lv.getIndex() + ", " : "").append("LoadCount=" + lv.getLoadCount()).append(", StoreCount=" + lv.getStoreCount()).append(lv.isSynthetic() ? ", Synthetic" : "").append(lv.getKind() == LocalVariable.VariableKind.PARAMETER && ((ParameterVariable)lv).isImplicit() ? ", Implicit" : "").append(")");
    }

    @Override
    public LineBuffer visitPostIncrement(PostIncrement postIncrement, None ctx) {
        return this.printDefault(postIncrement, postIncrement.isPositive() ? "ADD" : "SUB");
    }

    @Override
    public LineBuffer visitInstanceOf(InstanceOf instanceOf, None ctx) {
        return this.header(instanceOf).append(" " + this.importCollector.collect(instanceOf.getType())).append(this.argList((FastStream<Instruction>)instanceOf.getChildren().filterNot(e -> e instanceof Nop)));
    }

    @Override
    public LineBuffer visitInvoke(Invoke invoke, None ctx) {
        Method method = invoke.getMethod();
        return this.header(invoke).append(".").append(invoke.getKind().name()).append(this.optionalArg(invoke.getTarget())).append(" ").append(this.typeQualifier(method.getDeclaringClass(), invoke.getKind() == Invoke.InvokeKind.SPECIAL || method.isStatic())).append(this.parameterize(method, invoke.explicitTypeArgs)).append(method.getName()).append(this.argList(invoke.getArguments()));
    }

    @Override
    public LineBuffer visitInvokeDynamic(InvokeDynamic indy, None ctx) {
        Method bsm = indy.bootstrapHandle;
        return this.header(indy).append(" ").append(this.importCollector.collect(bsm.getDeclaringClass())).append(".").append(bsm.getName()).append(LineBuffer.paren((LineBuffer)FastStream.concat((Iterable[])new Iterable[]{FastStream.of((Object)indy.name), FastStream.of((Object[])indy.bootstrapArguments)}).map(this::debugIndyBSMArg).fold((Object)LineBuffer.of(), (a, b) -> {
            assert (a != null);
            if (!a.lines.isEmpty()) {
                a = a.append(", ");
            }
            return a.append((LineBuffer)b);
        }))).append(this.argList(indy.arguments));
    }

    private LineBuffer ldc(LdcInsn ldc) {
        return this.ldc(ldc, Objects.requireNonNull(ldc.getRawValue()));
    }

    private LineBuffer ldc(LdcInsn ldc, Object value) {
        return this.printDefault(ldc).append(" " + String.valueOf(value));
    }

    @Override
    public LineBuffer visitLdcBoolean(LdcBoolean ldcBoolean, None ctx) {
        return this.ldc(ldcBoolean);
    }

    @Override
    public LineBuffer visitLdcChar(LdcChar ldcChar, None ctx) {
        return this.ldc(ldcChar, "'" + EscapeUtils.escapeChar(ldcChar.getValue()) + "'");
    }

    @Override
    public LineBuffer visitLdcClass(LdcClass ldcClass, None ctx) {
        return this.ldc(ldcClass, this.importCollector.collect(ldcClass.getType()));
    }

    @Override
    public LineBuffer visitLdcNumber(LdcNumber ldcNumber, None ctx) {
        Number number = ldcNumber.getValue();
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        String suffix = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Float.class, Long.class}, (Object)number2, n)) {
            case 0 -> {
                Double v = (Double)number2;
                yield "D";
            }
            case 1 -> {
                Float v = (Float)number2;
                yield "F";
            }
            case 2 -> {
                Long l = (Long)number2;
                yield "L";
            }
            default -> "";
        };
        return this.ldc(ldcNumber, String.valueOf(ldcNumber.getValue()) + suffix);
    }

    @Override
    public LineBuffer visitLdcString(LdcString ldcString, None ctx) {
        return this.ldc(ldcString, "\"" + EscapeUtils.escapeChars(ldcString.getValue()) + "\"");
    }

    @Override
    public LineBuffer visitLeave(Leave leave, None ctx) {
        return this.header(leave).append(" ").append(leave.getTargetContainer().getEntryPoint().getName());
    }

    @Override
    public LineBuffer visitReturn(Return ret, None ctx) {
        return this.header(ret).append(this.optionalArg(ret.getValue()));
    }

    @Override
    public LineBuffer visitLoad(Load load, None ctx) {
        if (this.opts.hideLoads()) {
            return this.lines(load.getReference());
        }
        return this.printDefault(load);
    }

    @Override
    public LineBuffer visitLocalReference(LocalReference localRef, None ctx) {
        return this.printDefault(localRef).append(" ").append(localRef.variable.getUniqueName());
    }

    @Override
    public LineBuffer visitMethodDecl(MethodDecl methodDecl, None ctx) {
        boolean isLambda = methodDecl.getParentOrNull() != null && !(methodDecl.getParent() instanceof ClassDecl);
        return this.header(methodDecl, false).append(" ").append(!isLambda ? this.visitMethodHeader(methodDecl) : this.visitLambdaHeader(methodDecl)).append(this.braced(() -> this.visitMethodBody(methodDecl)));
    }

    private LineBuffer visitMethodHeader(MethodDecl methodDecl) {
        Method method = methodDecl.getMethod();
        return LineBuffer.of(AccessFlag.stringRep(method.getAccessFlags())).append(this.typeParamDecl(method.getTypeParameters(), true)).append(this.importCollector.collect(methodDecl.getReturnType())).append(" ").append(method.getName()).append(" ");
    }

    private LineBuffer visitLambdaHeader(MethodDecl lambda) {
        return LineBuffer.of().append(this.importCollector.collect(lambda.getReturnType())).append(" : ").append(this.importCollector.collect(lambda.getResultType())).append(" ");
    }

    private LineBuffer visitMethodBody(MethodDecl methodDecl) {
        LocalVariable variable;
        LineBuffer buffer = LineBuffer.of();
        Iterator<Object> iterator = methodDecl.parameters.iterator();
        while (iterator.hasNext()) {
            variable = (ParameterVariable)iterator.next();
            if (variable.isImplicit() && !this.opts.showImplicits()) continue;
            buffer = buffer.join(this.lines(variable));
        }
        iterator = methodDecl.variables.iterator();
        while (iterator.hasNext()) {
            variable = (LocalVariable)iterator.next();
            buffer = buffer.join(this.lines(variable));
        }
        if (methodDecl.hasBody()) {
            buffer = buffer.join(this.lines(methodDecl.getBody()));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitMethodReference(MethodReference mRef, None ctx) {
        Method method = mRef.getMethod();
        return this.header(mRef).append(this.optionalArg(mRef.getTarget())).append(" ").append(this.importCollector.collect(method.getDeclaringClass())).append("::").append(method.isConstructor() ? "new" : method.getName());
    }

    @Override
    public LineBuffer visitNew(New newInsn, None ctx) {
        Method method = newInsn.getMethod();
        return this.header(newInsn).append(newInsn.getTarget() != null ? ".INNER_INST" : "").append(" ").append(this.parameterize(method, newInsn.explicitTypeArgs)).append(this.importCollector.collect(newInsn.getResultType().asRaw())).append(this.parameterize(newInsn.getResultType(), newInsn.explicitClassTypeArgs)).append(this.argList(newInsn.getArguments())).append(newInsn.hasAnonymousClassDeclaration() ? this.lines(newInsn.getAnonymousClassDeclaration()).prepend(" ") : LineBuffer.of());
    }

    @Override
    public LineBuffer visitNewObject(NewObject newObject, None ctx) {
        return this.printDefault(newObject).append(" ").append(this.importCollector.collect(newObject.getType()));
    }

    @Override
    public LineBuffer visitSwitch(Switch switchInsn, None ctx) {
        return this.header(switchInsn).append(" ").append(this.argList(switchInsn.getValue())).append(" ").append(this.lines(switchInsn.getBody()));
    }

    @Override
    public LineBuffer visitSwitchTable(SwitchTable switchTable, None ctx) {
        return this.header(switchTable).append(this.optionalArg(switchTable.getValue())).append(" ").append(this.braced(() -> (LineBuffer)switchTable.sections.map(this::lines).fold((Object)LineBuffer.of(), (a, b) -> a.join((LineBuffer)b))));
    }

    @Override
    public LineBuffer visitSwitchSection(SwitchTable.SwitchSection switchSection, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        Iterator<Instruction> iterator = switchSection.values.iterator();
        while (iterator.hasNext()) {
            Instruction value = iterator.next();
            if (value instanceof Nop) {
                buffer = buffer.add("default: ");
                continue;
            }
            buffer = buffer.add("case ").append(this.lines(value)).append(": ");
        }
        return buffer.append(this.lines(switchSection.getBody()));
    }

    @Override
    public LineBuffer visitSynchronized(Synchronized synchInsn, None ctx) {
        return this.header(synchInsn).append(this.argList(synchInsn.getVariable())).append(" ").append(this.lines(synchInsn.getBody()));
    }

    @Override
    public LineBuffer visitTryCatch(TryCatch tryCatch, None ctx) {
        LineBuffer buffer = this.header(tryCatch).append(" ").append(this.lines(tryCatch.getTryBody()));
        Iterator<TryCatch.TryCatchHandler> iterator = tryCatch.handlers.iterator();
        while (iterator.hasNext()) {
            TryCatch.TryCatchHandler handler = iterator.next();
            buffer = buffer.join(this.lines(handler));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitTryCatchHandler(TryCatch.TryCatchHandler catchHandler, None ctx) {
        return this.header(catchHandler, false).append(" (").append(this.importCollector.collect(catchHandler.getVariable().getType())).append(" ").append(catchHandler.getVariable().variable.getUniqueName()).append(catchHandler.isUnprocessedFinally ? ", Unprocessed Finally" : "").append(") ").append(this.lines(catchHandler.getBody()));
    }

    @Override
    public LineBuffer visitTryFinally(TryFinally tryFinally, None ctx) {
        return this.header(tryFinally).append(" ").append(this.lines(tryFinally.getTryBody())).add("FINALLY ").append(this.lines(tryFinally.getFinallyBody()));
    }

    @Override
    public LineBuffer visitTryWithResources(TryWithResources tryWithResources, None ctx) {
        return this.header(tryWithResources).append(" ").append(this.argList(tryWithResources.getResource())).append(" ").append(this.lines(tryWithResources.getTryBody()));
    }

    @Override
    public LineBuffer visitWhileLoop(WhileLoop whileLoop, None ctx) {
        return this.header(whileLoop).append(" ").append(this.argList(whileLoop.getCondition())).append(" ").append(this.lines(whileLoop.getBody()));
    }
}

