package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;

/**
 * Created by covers1624 on 13/11/25.
 */
public interface TopLevelClassTransformer extends Transformer {

    /**
     * Transform a top-level class.
     * <p>
     * All methods have already been fully processed.
     * <p>
     * All nested/inner/local/anon classes are present and already fully processed.
     *
     * @param cInsn The class.
     * @param ctx   The context.
     */
    void transform(ClassDecl cInsn, ClassTransformContext ctx);

}
