package net.covers1624.coffeegrinder.type;

import net.covers1624.quack.collection.FastStream;

import java.util.List;

/**
 * Created by covers1624 on 23/7/21.
 */
public class ReferenceUnionType extends ReferenceType {

    private final List<ReferenceType> types;
    private final ReferenceType superType;

    ReferenceUnionType(List<ReferenceType> types) {
        this.types = List.copyOf(types);
        superType = TypeSystem.lub(types.toArray(new ReferenceType[0]));
        assert types.size() > 1;
    }

    @Override
    public String getName() {
        return FastStream.of(types).map(AType::getName).join(" | ");
    }

    @Override
    public String getFullName() {
        return FastStream.of(types).map(AType::getFullName).join(" | ");
    }

    public List<ReferenceType> getTypes() {
        return types;
    }

    @Override
    public ReferenceType getSuperType() {
        return superType;
    }

    @Override
    public String toString() {
        return "ReferenceUnionType(" + FastStream.of(types).map(Object::toString).join(" | ") + ")";
    }
}
