/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.LdcChar;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.TopLevelClassTransformer;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.util.None;

public class SwitchCleanup
extends SimpleInsnVisitor<ClassTransformContext>
implements TopLevelClassTransformer {
    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        cInsn.accept(this, ctx);
    }

    @Override
    public None visitSwitch(Switch swtch, ClassTransformContext ctx) {
        super.visitSwitch(swtch, ctx);
        SwitchCleanup.stripRedundantDefaultCases(swtch, ctx);
        this.removeRedundantDefault(swtch, ctx);
        return NONE;
    }

    @Override
    public None visitMethodDecl(MethodDecl methodDecl, ClassTransformContext ctx) {
        boolean doPush = methodDecl.getParent() instanceof ClassDecl;
        if (doPush) {
            ctx.pushStep("Cleanup method " + methodDecl.getMethod().getName(), Step.StepContextType.METHOD);
        }
        super.visitMethodDecl(methodDecl, ctx);
        if (doPush) {
            ctx.popStep();
        }
        return NONE;
    }

    private static void stripRedundantDefaultCases(Switch swtch, ClassTransformContext ctx) {
        SwitchTable table = swtch.getSwitchTable();
        if (table.tableInfo == null) {
            return;
        }
        SwitchTable.SwitchSection defaultSection = (SwitchTable.SwitchSection)table.sections.filter(e -> e.values.anyMatch(v -> v instanceof Nop)).onlyOrDefault();
        if (defaultSection == null) {
            return;
        }
        SwitchTable.TableInfo tI = table.tableInfo;
        ctx.pushStep("Remove redundant default table switch case labels.");
        block4: for (Instruction e2 : defaultSection.values.toList()) {
            Objects.requireNonNull(e2);
            int n = 0;
            block5: while (true) {
                Instruction instruction;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LdcNumber.class, LdcChar.class}, (Object)instruction, n)) {
                    case 0: {
                        LdcNumber num = (LdcNumber)instruction;
                        if (!SwitchCleanup.betweenE(tI.min(), num.intValue(), tI.max())) {
                            n = 1;
                            continue block5;
                        }
                        e2.remove();
                        continue block4;
                    }
                    case 1: {
                        LdcChar chr = (LdcChar)instruction;
                        if (!SwitchCleanup.betweenE(tI.min(), chr.getValue(), tI.max())) {
                            n = 2;
                            continue block5;
                        }
                        e2.remove();
                        continue block4;
                    }
                }
                break;
            }
        }
        ctx.popStep();
    }

    private static boolean betweenE(int min, int value, int max) {
        return min < value && value < max;
    }

    public void removeRedundantDefault(Switch swtch, ClassTransformContext ctx) {
        BlockContainer body = swtch.getBody();
        SwitchTable table = swtch.getSwitchTable();
        SwitchTable.SwitchSection defaultSection = (SwitchTable.SwitchSection)table.sections.filter(e -> e.values.size() == 1 && e.values.first() instanceof Nop).onlyOrDefault();
        if (defaultSection == null) {
            return;
        }
        if (BranchLeaveMatching.matchLeave(defaultSection.getBody(), body) == null) {
            return;
        }
        ctx.pushStep("Remove redundant default case");
        defaultSection.remove();
        ctx.popStep();
    }
}

