/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SemanticMatcher;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorExit;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.TransformerUtils;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.ColUtils;
import org.jetbrains.annotations.Nullable;

public class TryCatches
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        ctx.pushStep("Inline handler variable stores");
        TryCatches.inlinedHandlerVariables(function, ctx);
        ctx.popStep();
        ctx.pushStep("Convert Finally Handlers");
        TryCatches.transformFinallyBlocks(function, ctx);
        ctx.popStep();
        ctx.pushStep("Combine handlers");
        TryCatches.combineHandlers(function, ctx);
        ctx.popStep();
        ctx.pushStep("Capture try exit blocks");
        TryCatches.captureTryBodyExitBlocks(function, ctx);
        ctx.popStep();
        ctx.pushStep("Capture handler blocks");
        TryCatches.captureBlocks(function, ctx);
        ctx.popStep();
    }

    public static void inlinedHandlerVariables(MethodDecl function, MethodTransformContext ctx) {
        function.descendantsToList(TryCatch.TryCatchHandler.class).forEach(handler -> {
            LocalReference handlerVarDecl = handler.getVariable();
            LocalVariable handlerVar = handlerVarDecl.variable;
            assert (handlerVar.getKind() == LocalVariable.VariableKind.STACK_SLOT);
            assert (handlerVar.getLoadCount() == 1);
            BlockContainer body = handler.getBody();
            Block bodyBlock = (Block)body.blocks.only();
            Branch firstBranch = (Branch)bodyBlock.instructions.only();
            Block target = firstBranch.getTargetBlock();
            assert (target.getIncomingEdgeCount() == 1);
            Store varStore = LoadStoreMatching.matchStoreLocalLoadLocal(target.getFirstChild(), handlerVar);
            assert (varStore != null);
            LocalVariable handlerLocalVar = varStore.getVariable();
            ctx.pushStep("Inline handler variable " + handlerLocalVar.getUniqueName());
            handlerLocalVar.setType(handlerVar.getType());
            handlerVarDecl.replaceWith(new LocalReference(handlerLocalVar));
            varStore.remove();
            if (target.instructions.size() == 1) {
                firstBranch.replaceWith(target.getFirstChild());
                target.remove();
            }
            ctx.popStep();
        });
    }

    private static void combineHandlers(MethodDecl function, MethodTransformContext ctx) {
        function.accept(new SimpleInsnVisitor<MethodTransformContext>(){

            @Override
            public None visitTryCatch(TryCatch tryCatch, MethodTransformContext ctx) {
                while (true) {
                    Object object;
                    BlockContainer container = tryCatch.getTryBody();
                    if (container.blocks.size() != 1) break;
                    Block block = (Block)container.blocks.first();
                    if (block.instructions.size() != 1 || !((object = block.instructions.first()) instanceof TryCatch)) break;
                    TryCatch inner = (TryCatch)object;
                    ctx.pushStep("Combine " + block.getName() + " into " + ((Block)tryCatch.getParent()).getName());
                    tryCatch.handlers.addFirst((TryCatch.TryCatchHandler)inner.handlers.first());
                    tryCatch.setTryBody(inner.getTryBody());
                    ctx.popStep();
                }
                return (None)super.visitTryCatch(tryCatch, ctx);
            }
        }, ctx);
    }

    private static void captureTryBodyExitBlocks(MethodDecl function, MethodTransformContext ctx) {
        function.descendantsOfType(TryCatch.class).reversed().forEach(tryCatch -> {
            Instruction firstInsn;
            BlockContainer tryBody = tryCatch.getTryBody();
            Block tryBlock = (Block)tryCatch.getParent();
            LinkedList<Block> blocksToMove = new LinkedList<Block>();
            for (Block b = (Block)tryBlock.getNextSiblingOrNull(); b != null && ((firstInsn = b.getFirstChild()) instanceof Branch || firstInsn instanceof Return) && b.getBranches().allMatch(e -> e.isDescendantOf(tryBody)); b = (Block)b.getNextSiblingOrNull()) {
                blocksToMove.add(b);
            }
            if (blocksToMove.isEmpty()) {
                return;
            }
            ctx.pushStep(tryBody.getEntryPoint().getName());
            BlockContainer parentContainer = (BlockContainer)tryBlock.getParent();
            TransformerUtils.moveBlocksIntoContainer(blocksToMove, parentContainer, tryBody, null);
            ctx.popStep();
        });
    }

    private static void captureBlocks(MethodDecl function, MethodTransformContext ctx) {
        for (TryCatch.TryCatchHandler handler : function.descendantsToList(TryCatch.TryCatchHandler.class)) {
            ctx.pushStep("Capture blocks " + handler.getBody().getEntryPoint().getName());
            TryCatches.captureCatchBlocks(handler.getBody());
            ctx.popStep();
        }
    }

    private static void captureCatchBlocks(BlockContainer catchContainer) {
        Block catchEntry = catchContainer.getEntryPoint();
        Object object = catchEntry.instructions.only();
        if (!(object instanceof Branch)) {
            return;
        }
        Branch entryBranch = (Branch)object;
        Block realCatchEntry = entryBranch.getTargetBlock();
        if (realCatchEntry.getIncomingEdgeCount() > 1) {
            return;
        }
        BlockContainer realCatchContainer = (BlockContainer)realCatchEntry.getParent();
        TryFinally containingFinally = (TryFinally)catchContainer.ancestorsOfType(TryFinally.class).firstOrDefault();
        if (containingFinally != null && !realCatchContainer.isDescendantOf(containingFinally)) {
            return;
        }
        ControlFlowGraph graph = new ControlFlowGraph((BlockContainer)realCatchEntry.getParent());
        ControlFlowNode node = graph.getNode(realCatchEntry);
        LinkedList<Block> blocks = new LinkedList<Block>();
        for (Block block = realCatchEntry; block != null && node.dominates(graph.getNode(block)); block = (Block)block.getNextSiblingOrNull()) {
            blocks.add(block);
        }
        TransformerUtils.moveBlocksIntoContainer(blocks, graph.container, catchContainer, null);
    }

    private static void transformFinallyBlocks(MethodDecl function, MethodTransformContext ctx) {
        TryCatch.TryCatchHandler handler;
        while ((handler = TryCatches.findUnprocessedFinally(function)) != null) {
            TryCatch tryCatch = (TryCatch)handler.getParent();
            assert (tryCatch.handlers.size() == 1);
            BlockContainer tryBody = tryCatch.getTryBody();
            BlockContainer parentContainer = (BlockContainer)tryCatch.getParent().getParent();
            BlockContainer handlerBodyContainer = handler.getBody();
            Block entryPoint = handlerBodyContainer.getEntryPoint();
            ctx.pushStep("Process finally " + entryPoint.getName());
            Branch finallyBranch = (Branch)entryPoint.instructions.first();
            Block finallyBody = finallyBranch.getTargetBlock();
            LocalVariable exVariable = handler.getVariable().variable;
            LinkedHashSet<Block> finallyBlocks = new LinkedHashSet<Block>();
            Store finallyEndpoint = TryCatches.findFinallyEndpoint(finallyBlocks, finallyBody, exVariable);
            assert (finallyEndpoint != null || exVariable.getLoadCount() == 0);
            LinkedList tryBodyExits = tryBody.descendantsOfType(Branch.class).filter(e -> !e.getTargetContainer().isDescendantOf(tryBody)).map(e -> TryCatches.extractMonitorExitBlock(tryCatch, e, ctx)).map(Branch::getTargetBlock).distinct().toLinkedList();
            tryBodyExits.forEach(exitTarget -> {
                ctx.pushStep("Match try exit " + exitTarget.getName());
                SemanticMatcher matcher = new SemanticMatcher(finallyEndpoint);
                if (!matcher.equivalent(finallyBody, (Instruction)exitTarget)) {
                    throw new IllegalStateException("Exit branch of Try container " + exitTarget.getName() + " does not pass through a semantically matching finally block: " + finallyBody.getName());
                }
                ArrayList<Block> blocksToRemove = new ArrayList<Block>(matcher.blockMap.values());
                assert (finallyEndpoint == null || matcher.matchedEndpoint != null);
                ctx.pushStep("Rewrite exits");
                Block newExit = TryCatches.rewriteExits(tryBody, exitTarget, matcher.matchedEndpoint);
                ctx.popStep();
                ctx.pushStep("Delete duplicate blocks");
                for (Block block : blocksToRemove) {
                    if (block == newExit || !block.isConnected()) continue;
                    block.remove();
                }
                ctx.popStep();
                if (newExit != null) {
                    TryCatches.tryInlineTryFinallyBodyExitBlock(tryCatch, newExit, finallyBody, ctx);
                }
                ctx.popStep();
            });
            BlockContainer tryFinallyHandler = new BlockContainer();
            tryCatch.replaceWith(new TryFinally(tryBody, tryFinallyHandler).withOffsets(tryCatch));
            if (finallyEndpoint != null) {
                Block finallyEndpointBlock = TryCatches.getOrSplitBlockStartsAt(finallyEndpoint);
                finallyBlocks.add(finallyEndpointBlock);
                finallyEndpointBlock.instructions.clear();
                finallyEndpointBlock.instructions.add(new Leave(tryFinallyHandler));
            }
            TransformerUtils.moveBlocksIntoContainer(finallyBlocks, parentContainer, tryFinallyHandler, null);
            ctx.popStep();
        }
    }

    @Nullable
    private static TryCatch.TryCatchHandler findUnprocessedFinally(Instruction insn) {
        if (insn instanceof TryCatch) {
            TryCatch tc = (TryCatch)insn;
            Iterator<TryCatch.TryCatchHandler> iterator = tc.handlers.iterator();
            while (iterator.hasNext()) {
                TryCatch.TryCatchHandler handler = iterator.next();
                if (!handler.isUnprocessedFinally) continue;
                return handler;
            }
        }
        for (Instruction c = insn.getFirstChildOrNull(); c != null; c = c.getNextSiblingOrNull()) {
            TryCatch.TryCatchHandler r = TryCatches.findUnprocessedFinally(c);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    private static Block rewriteExits(BlockContainer tryBody, Block tryBodyExit, @Nullable Instruction matchedEndpoint) {
        if (matchedEndpoint == null) {
            tryBodyExit.getBranches().toList().forEach(e -> e.replaceWith(new Leave(tryBody)));
            return null;
        }
        Block matchedEndpointBlock = TryCatches.getOrSplitBlockStartsAt(matchedEndpoint);
        for (Branch exit : tryBodyExit.getBranches().toList()) {
            exit.replaceWith(new Branch(matchedEndpointBlock));
        }
        return matchedEndpointBlock;
    }

    private static Block getOrSplitBlockStartsAt(Instruction start) {
        Branch branch;
        Block jmpBlock;
        if (start instanceof Branch && (jmpBlock = (branch = (Branch)start).getTargetBlock()).getBytecodeOffset() >= start.getBytecodeOffset()) {
            return jmpBlock;
        }
        Block block = (Block)start.getParent();
        if (block.getFirstChild() == start) {
            return block;
        }
        Block splitBlock = block.extractRange(start, block.getLastChild());
        block.instructions.add(new Branch(splitBlock));
        block.insertAfter(splitBlock);
        return splitBlock;
    }

    private static void tryInlineTryFinallyBodyExitBlock(TryCatch processingFinally, Block block, Block finallyBody, MethodTransformContext ctx) {
        if (block.getBytecodeOffset() > finallyBody.getBytecodeOffset()) {
            return;
        }
        if (!ColUtils.allMatch(block.getBranches(), br -> TryCatches.getContainingFinally(br) == processingFinally)) {
            return;
        }
        Instruction instruction = block.getLastChild();
        if (!(instruction instanceof Return)) {
            return;
        }
        Return ret = (Return)instruction;
        Instruction prev = ret.getPrevSiblingOrNull();
        if (prev != null) {
            if (!(prev instanceof Store)) {
                return;
            }
            Store store = (Store)prev;
            if (LoadStoreMatching.matchLoadLocal(ret.getValue(), store.getVariable()) == null) {
                return;
            }
            if (block.getFirstChild() != store) {
                return;
            }
        }
        Block highestBlock = (Block)block.getBranches().map(br -> br.firstAncestorOfType(Block.class)).maxBy(Instruction::getBytecodeOffset);
        ctx.pushStep("Move synthetic return block " + block.getName() + " into try body");
        highestBlock.insertAfter(block);
        ctx.popStep();
    }

    private static TryCatch getContainingFinally(Branch br) {
        return (TryCatch)br.ancestorsOfType(TryCatch.class).filter(tc -> ((TryCatch.TryCatchHandler)tc.handlers.only()).isUnprocessedFinally).first();
    }

    private static Branch extractMonitorExitBlock(TryCatch tryCatch, Branch exit, MethodTransformContext ctx) {
        Instruction prev = exit.getPrevSiblingOrNull();
        if (!(prev instanceof MonitorExit)) {
            return exit;
        }
        Block block = (Block)exit.getParent();
        if (block.getParent().getParent() != tryCatch) {
            return exit;
        }
        if (block.getFirstChild() == prev.getPrevSibling()) {
            return (Branch)block.getBranches().first();
        }
        ctx.pushStep("Split MONITOR_EXIT block out of try");
        Block split = block.extractRange(exit.getPrevSibling().getPrevSibling(), exit);
        assert (split.getFirstChild() instanceof Store);
        Branch newBranch = new Branch(split);
        block.instructions.add(newBranch);
        Block tryCatchBlock = (Block)tryCatch.getParent();
        tryCatchBlock.insertAfter(split);
        ctx.popStep();
        return newBranch;
    }

    @Nullable
    private static Store findFinallyEndpoint(Set<Block> visited, Block block, LocalVariable exceptionVariable) {
        Throw thr;
        Store store;
        if (!visited.add(block)) {
            return null;
        }
        Instruction instruction = block.getLastChild();
        if (instruction instanceof Throw && (store = LoadStoreMatching.matchStoreLocalLoadLocal((thr = (Throw)instruction).getPrevSiblingOrNull(), exceptionVariable)) != null) {
            assert (LoadStoreMatching.matchLoadLocal(thr.getArgument(), store.getVariable()) != null);
            return store;
        }
        return (Store)block.descendantsOfType(Branch.class).map(br -> TryCatches.findFinallyEndpoint(visited, br.getTargetBlock(), exceptionVariable)).filter(Objects::nonNull).distinct().onlyOrDefault();
    }
}

