/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi.java11;

import java.io.InputStream;
import java.net.http.HttpResponse;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HeaderList;
import net.covers1624.quack.net.httpapi.WebBody;
import net.covers1624.quack.net.httpapi.java11.Java11EngineRequest;
import org.jetbrains.annotations.Nullable;

public class Java11EngineResponse
implements EngineResponse {
    private final Java11EngineRequest request;
    private final HttpResponse<InputStream> response;
    private final HeaderList headers = new HeaderList();
    private final WebBody body;

    public Java11EngineResponse(Java11EngineRequest request, HttpResponse<InputStream> response) {
        this.request = request;
        this.response = response;
        this.headers.addAllMulti(response.headers().map());
        String contentLen = this.headers.get("Content-Length");
        this.body = new ResponseBodyWrapper(response, contentLen != null && !contentLen.isEmpty() ? Long.parseLong(contentLen) : -1L, this.headers.get("Content-Type"));
    }

    @Override
    public EngineRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.response.statusCode();
    }

    @Override
    public String message() {
        return "";
    }

    @Override
    public HeaderList headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public WebBody body() {
        return this.body;
    }

    @Override
    public void close() {
    }

    private static final class ResponseBodyWrapper
    implements WebBody {
        private final HttpResponse<InputStream> response;
        private final long contentLength;
        @Nullable
        private final String contentType;

        private ResponseBodyWrapper(HttpResponse<InputStream> response, long contentLength, @Nullable String contentType) {
            this.response = response;
            this.contentLength = contentLength;
            this.contentType = contentType;
        }

        @Override
        public InputStream open() {
            return this.response.body();
        }

        @Override
        public boolean multiOpenAllowed() {
            return false;
        }

        @Override
        public long length() {
            return this.contentLength;
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }
}

