package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

/**
 * Created by covers1624 on 29/4/22.
 */
public class RawField extends Field {

    private final Field decl;
    private final AType type;

    public RawField(Field decl, AType type) {
        this.decl = decl;
        this.type = type;
    }

    //@formatter:off
    @Override public String getName() { return decl.getName(); }
    @Override public AType getType() { return type; }
    @Override public EnumBitSet<AccessFlag> getAccessFlags() { return decl.getAccessFlags(); }
    @Nullable @Override public Object getConstantValue() { return decl.getConstantValue(); }
    @Override public Field asRaw() { return this; }
    @Override public Type getDescriptor() { return decl.getDescriptor(); }
    @Override public ClassType getDeclaringClass() { return decl.getDeclaringClass(); }
    public Field getDeclaration() { return decl; }
    //@formatter:on
}
