/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public final class FieldReference
extends Reference {
    @Nullable
    private final ClassType targetClassType;
    private Field field;
    private final InstructionSlot<Instruction> target = new InstructionSlot(this);

    public FieldReference(Field field) {
        this(field, new Nop());
    }

    public FieldReference(Field field, Instruction target) {
        this(null, field, target);
    }

    public FieldReference(@Nullable ClassType targetClassType, Field field, Instruction target) {
        this.targetClassType = targetClassType;
        this.field = field;
        this.target.set(target);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        if (this.getTarget() instanceof LoadThis) {
            return InstructionFlag.NONE;
        }
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public AType getType() {
        return this.field.getType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitFieldReference(this, ctx);
    }

    @Override
    public FieldReference copy() {
        return new FieldReference(this.targetClassType, this.field, this.getTarget().copy());
    }

    @Nullable
    public ClassType getTargetClassType() {
        return this.targetClassType;
    }

    public Instruction getTarget() {
        return this.target.get();
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }
}

