/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.Objects;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.DoWhileLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.LogicOr;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import org.jetbrains.annotations.Nullable;

public class ScopeVisitor<R, C>
extends InsnVisitor<R, C> {
    private Scope scope = new Scope(null, null);
    private final InsnVisitor<R, C> inner;
    @Nullable
    private ConditionalScopeHelper conditionalScopeHelper = null;
    private ConditionalVars retConditionalScope = ConditionalVars.NONE;

    public ScopeVisitor(InsnVisitor<R, C> inner) {
        this.inner = inner;
    }

    public boolean currentScopeHasDeclarations() {
        return this.scope.var != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R visit(Instruction insn, C ctx) {
        ConditionalScopeHelper h = this.conditionalScopeHelper;
        this.conditionalScopeHelper = null;
        try {
            Object r = switch ((h != null ? h.getRule(insn) : ScopeVisitRule.NONE).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> insn.accept(this, ctx);
                case 1 -> h.visitCollect(() -> insn.accept(this, ctx));
                case 2 -> h.visitCollectTrue(() -> insn.accept(this, ctx));
                case 3 -> h.visitCollectFalse(() -> insn.accept(this, ctx));
                case 4 -> h.visitTrue(() -> insn.accept(this, ctx));
                case 5 -> h.visitFalse(() -> insn.accept(this, ctx));
            };
            return r;
        }
        finally {
            this.conditionalScopeHelper = h;
            this.retConditionalScope = ConditionalVars.NONE;
        }
    }

    @Override
    public R visitDefault(Instruction insn, C ctx) {
        return insn.accept(this.inner, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitInstanceOf(InstanceOf instanceOf, C ctx) {
        Instruction instruction;
        Object r;
        try {
            r = super.visitInstanceOf(instanceOf, ctx);
            instruction = instanceOf.getPattern();
        }
        catch (Throwable throwable) {
            Instruction instruction2 = instanceOf.getPattern();
            if (instruction2 instanceof LocalReference) {
                LocalReference ref = (LocalReference)instruction2;
                this.retConditionalScope = new ConditionalVars(new VarList(ref.variable, null), null);
            }
            throw throwable;
        }
        if (instruction instanceof LocalReference) {
            LocalReference ref = (LocalReference)instruction;
            this.retConditionalScope = new ConditionalVars(new VarList(ref.variable, null), null);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitIfInstruction(IfInstruction ifInsn, C ctx) {
        boolean falseFallthrough;
        boolean trueFallthrough;
        Object r;
        this.conditionalScopeHelper = new ConditionalScopeHelper(ifInsn, ScopeVisitRule.COLLECT, ScopeVisitRule.TRUE, ScopeVisitRule.FALSE);
        try {
            r = super.visitIfInstruction(ifInsn, ctx);
            trueFallthrough = !ifInsn.getTrueInsn().hasFlag(InstructionFlag.END_POINT_UNREACHABLE);
        }
        catch (Throwable throwable) {
            boolean falseFallthrough2;
            boolean trueFallthrough2 = !ifInsn.getTrueInsn().hasFlag(InstructionFlag.END_POINT_UNREACHABLE);
            boolean bl = falseFallthrough2 = !ifInsn.getFalseInsn().hasFlag(InstructionFlag.END_POINT_UNREACHABLE);
            if (trueFallthrough2 && !falseFallthrough2) {
                this.declare(this.conditionalScopeHelper.scope.trueVars);
            }
            if (!trueFallthrough2 && falseFallthrough2) {
                this.declare(this.conditionalScopeHelper.scope.falseVars);
            }
            throw throwable;
        }
        boolean bl = falseFallthrough = !ifInsn.getFalseInsn().hasFlag(InstructionFlag.END_POINT_UNREACHABLE);
        if (trueFallthrough && !falseFallthrough) {
            this.declare(this.conditionalScopeHelper.scope.trueVars);
        }
        if (!trueFallthrough && falseFallthrough) {
            this.declare(this.conditionalScopeHelper.scope.falseVars);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitLogicNot(LogicNot logicNot, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(logicNot, ScopeVisitRule.COLLECT);
        try {
            Object r = super.visitLogicNot(logicNot, ctx);
            return r;
        }
        finally {
            this.retConditionalScope = this.conditionalScopeHelper.scope.inverted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitLogicAnd(LogicAnd logicAnd, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(logicAnd, ScopeVisitRule.COLLECT, ScopeVisitRule.COLLECT_TRUE);
        try {
            Object r = super.visitLogicAnd(logicAnd, ctx);
            return r;
        }
        finally {
            this.retConditionalScope = this.conditionalScopeHelper.scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitLogicOr(LogicOr logicOr, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(logicOr, ScopeVisitRule.COLLECT, ScopeVisitRule.COLLECT_FALSE);
        try {
            Object r = super.visitLogicOr(logicOr, ctx);
            return r;
        }
        finally {
            this.retConditionalScope = this.conditionalScopeHelper.scope;
        }
    }

    @Override
    public R visitTernary(Ternary ternary, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(ternary, ScopeVisitRule.COLLECT, ScopeVisitRule.TRUE, ScopeVisitRule.FALSE);
        return super.visitTernary(ternary, ctx);
    }

    @Override
    public R visitMethodDecl(MethodDecl methodDecl, C ctx) {
        return (R)this.withScope(() -> {
            methodDecl.parameters.forEach(this::declare);
            return this.visitDefault(methodDecl, ctx);
        });
    }

    @Override
    public R visitBlockContainer(BlockContainer container, C ctx) {
        return this.visitWithScope(container, ctx);
    }

    @Override
    public R visitSwitchSection(SwitchTable.SwitchSection switchSection, C ctx) {
        return this.visitWithScope(switchSection, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitWhileLoop(WhileLoop whileLoop, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(whileLoop, ScopeVisitRule.COLLECT, ScopeVisitRule.TRUE);
        try {
            Object r = super.visitWhileLoop(whileLoop, ctx);
            return r;
        }
        finally {
            this.declare(this.conditionalScopeHelper.scope.falseVars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitForLoop(ForLoop loop, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(loop, ScopeVisitRule.NONE, ScopeVisitRule.COLLECT, ScopeVisitRule.TRUE, ScopeVisitRule.TRUE);
        try {
            R r = this.visitWithScope(loop, ctx);
            return r;
        }
        finally {
            this.declare(this.conditionalScopeHelper.scope.falseVars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitDoWhileLoop(DoWhileLoop doWhileLoop, C ctx) {
        this.conditionalScopeHelper = new ConditionalScopeHelper(doWhileLoop, ScopeVisitRule.NONE, ScopeVisitRule.COLLECT);
        try {
            Object r = super.visitDoWhileLoop(doWhileLoop, ctx);
            return r;
        }
        finally {
            this.declare(this.conditionalScopeHelper.scope.falseVars);
        }
    }

    @Override
    public R visitForEachLoop(ForEachLoop forEachLoop, C ctx) {
        return this.visitWithScope(forEachLoop, ctx);
    }

    @Override
    public R visitTryCatchHandler(TryCatch.TryCatchHandler catchHandler, C ctx) {
        return this.visitWithScope(catchHandler, ctx);
    }

    @Override
    public R visitTryWithResources(TryWithResources tryWithResources, C ctx) {
        return this.visitWithScope(tryWithResources, ctx);
    }

    private R visitWithScope(Instruction insn, C ctx) {
        return (R)this.withScope(() -> this.visitDefault(insn, ctx));
    }

    private R withScope(Supplier<R> func) {
        this.scope = new Scope(this.scope, null);
        try {
            R r = func.get();
            return r;
        }
        finally {
            while (this.scope.var != null) {
                this.scope = Objects.requireNonNull(this.scope.prev);
            }
            this.scope = Objects.requireNonNull(this.scope.prev);
        }
    }

    private void declare(@Nullable VarList vars) {
        while (vars != null) {
            this.declare(vars.var);
            vars = vars.next;
        }
    }

    @Override
    public R visitLocalReference(LocalReference local, C ctx) {
        Object r = super.visitLocalReference(local, ctx);
        if (local.isConnected() && !local.isReadFrom() && !this.isDeclared(local.variable) && !(local.getParent() instanceof InstanceOf)) {
            this.declare(local.variable);
        }
        return r;
    }

    private void declare(LocalVariable var) {
        this.scope = new Scope(this.scope, var);
    }

    public boolean isDeclared(LocalVariable var) {
        Scope s = this.scope;
        while (s != null) {
            if (s.var == var) {
                return true;
            }
            s = s.prev;
        }
        return false;
    }

    public boolean isDeclared(String name) {
        return this.getVariableInScope(name) != null;
    }

    @Nullable
    public LocalVariable getVariableInScope(String name) {
        Scope s = this.scope;
        while (s != null) {
            if (s.var != null && s.var.getName().equals(name)) {
                return s.var;
            }
            s = s.prev;
        }
        return null;
    }

    private record Scope(@Nullable Scope prev, @Nullable LocalVariable var) {
    }

    private class ConditionalScopeHelper {
        public ConditionalVars scope = ConditionalVars.NONE;
        private final ScopeVisitRule[] rules;
        @Nullable
        private Instruction nextChild;
        private int childIndex;

        private ConditionalScopeHelper(Instruction insn, ScopeVisitRule ... rules) {
            this.rules = rules;
            this.nextChild = insn.getFirstChildOrNull();
        }

        public ScopeVisitRule getRule(Instruction insn) {
            if (insn != this.nextChild) {
                throw new IllegalStateException("Visited children in the wrong order?");
            }
            this.nextChild = this.nextChild.getNextSiblingOrNull();
            return this.rules[this.childIndex++];
        }

        private R withScope(@Nullable VarList vars, Supplier<R> func) {
            return ScopeVisitor.this.withScope(() -> {
                ScopeVisitor.this.declare(vars);
                return func.get();
            });
        }

        private R visitCollect(Supplier<R> func) {
            try {
                Object r = func.get();
                return r;
            }
            finally {
                this.scope = ScopeVisitor.this.retConditionalScope;
            }
        }

        private R visitCollectTrue(Supplier<R> func) {
            try {
                Object r = this.visitTrue(func);
                return r;
            }
            finally {
                this.scope = new ConditionalVars(this.combine(this.scope.trueVars, ScopeVisitor.this.retConditionalScope.trueVars), null);
            }
        }

        private R visitCollectFalse(Supplier<R> func) {
            try {
                Object r = this.visitFalse(func);
                return r;
            }
            finally {
                this.scope = new ConditionalVars(null, this.combine(this.scope.falseVars, ScopeVisitor.this.retConditionalScope.falseVars));
            }
        }

        public R visitTrue(Supplier<R> func) {
            return this.withScope(this.scope.trueVars, func);
        }

        public R visitFalse(Supplier<R> func) {
            return this.withScope(this.scope.falseVars, func);
        }

        @Nullable
        private VarList combine(@Nullable VarList a, @Nullable VarList b) {
            while (b != null) {
                a = new VarList(b.var, a);
                b = b.next;
            }
            return a;
        }
    }

    private record ConditionalVars(@Nullable VarList trueVars, @Nullable VarList falseVars) {
        public static final ConditionalVars NONE = new ConditionalVars(null, null);

        public ConditionalVars inverted() {
            return new ConditionalVars(this.falseVars, this.trueVars);
        }
    }

    static enum ScopeVisitRule {
        NONE,
        COLLECT,
        COLLECT_TRUE,
        COLLECT_FALSE,
        TRUE,
        FALSE;

    }

    private record VarList(LocalVariable var, @Nullable VarList next) {
    }
}

