/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.TryInstruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class TryWithResources
extends TryInstruction {
    private final InstructionSlot<Instruction> resource = new InstructionSlot(this);
    private final InstructionSlot<BlockContainer> tryBody = new InstructionSlot(this);

    public TryWithResources(Instruction resource, BlockContainer body) {
        this.setResource(resource);
        this.setTryBody(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTryWithResources(this, ctx);
    }

    public Instruction getResource() {
        return this.resource.get();
    }

    public void setResource(Instruction resource) {
        this.resource.set(resource);
    }

    @Override
    public BlockContainer getTryBody() {
        return this.tryBody.get();
    }

    @Override
    public void setTryBody(BlockContainer tryBody) {
        this.tryBody.set(tryBody);
    }
}

