/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.Inlining;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.JavaVersion;
import org.jetbrains.annotations.Nullable;

public class ConditionDetection
implements BlockTransformer {
    private BlockTransformContext ctx;

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        this.ctx = ctx;
        Instruction instruction = block.instructions.secondToLastOrDefault();
        if (instruction instanceof IfInstruction) {
            IfInstruction ifInsn = (IfInstruction)instruction;
            this.handleIfInstruction(block, ifInsn);
        } else {
            ConditionDetection.inlineExitBranch(block, ctx);
        }
    }

    private void handleIfInstruction(Block block, IfInstruction ifInsn) {
        this.invertIf(ifInsn);
        while (this.inlineTrueBranch(ifInsn) || ConditionDetection.inlineExitBranch(block, this.ctx)) {
            boolean needsInvert = this.prepareShortCircuitOr(ifInsn) || this.prepareInvertedTernary(ifInsn);
            this.tryMergeTrueExitWithFallthrough(block, ifInsn);
            this.introduceShortCircuit(ifInsn);
            this.produceTernary(ifInsn);
            if (!needsInvert) continue;
            this.invertIf(ifInsn);
        }
        this.mergeExitsForInline(block, ifInsn);
    }

    private boolean prepareInvertedTernary(IfInstruction ifInsn) {
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return false;
        }
        Block ternaryThenCond = (Block)instruction;
        IfInstruction thenIf = Inlining.matchWithPotentialInline(ternaryThenCond.getFirstChildOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (thenIf == null) {
            return false;
        }
        IfInstruction elseIf = Inlining.matchWithPotentialInline(ifInsn.getNextSiblingOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (elseIf == null) {
            return false;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getTrueInsn(), elseIf.getNextSiblingOrNull())) {
            return false;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getNextSiblingOrNull(), elseIf.getTrueInsn())) {
            return false;
        }
        this.ctx.pushStep("Prepare inverted ternary");
        this.invertIf(elseIf);
        this.ctx.popStep();
        return true;
    }

    private boolean inlineTrueBranch(IfInstruction ifInsn) {
        int nextInsnBytecodeOffset;
        if (!ConditionDetection.canInline(ifInsn.getTrueInsn())) {
            return false;
        }
        assert (IfMatching.matchNopFalseIf(ifInsn) != null);
        Block targetBlock = ((Branch)ifInsn.getTrueInsn()).getTargetBlock();
        Instruction fallthrough = ifInsn.getNextSibling();
        int n = nextInsnBytecodeOffset = !(fallthrough instanceof Branch) && !(fallthrough instanceof Leave) ? fallthrough.getBytecodeOffset() : -1;
        if (nextInsnBytecodeOffset >= 0 && nextInsnBytecodeOffset < targetBlock.getBytecodeOffset()) {
            return false;
        }
        this.ctx.pushStep("Inline true-branch");
        ifInsn.setTrueInsn(targetBlock);
        this.tryProducePatternMatch(ifInsn);
        if (targetBlock.instructions.size() == 1) {
            targetBlock.replaceWith(targetBlock.getFirstChild());
        }
        this.ctx.popStep();
        return true;
    }

    private void tryProducePatternMatch(IfInstruction ifInsn) {
        if (this.ctx.classVersion.ordinal() < JavaVersion.JAVA_17.ordinal()) {
            return;
        }
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return;
        }
        Block trueBlock = (Block)instruction;
        Store store = LoadStoreMatching.matchStoreLocal(trueBlock.getFirstChild());
        if (!(store instanceof Store)) {
            return;
        }
        Store store2 = store;
        LocalVariable variable = store2.getVariable();
        if (variable.getKind() != LocalVariable.VariableKind.LOCAL) {
            return;
        }
        Instruction instruction2 = store2.getValue();
        if (!(instruction2 instanceof Cast)) {
            return;
        }
        Cast cast = (Cast)instruction2;
        Instruction condPushFrom = LoadStoreMatching.matchPushForPop(ifInsn.getCondition());
        if (condPushFrom == null || condPushFrom.getParent() != ifInsn.getPrevSiblingOrNull()) {
            return;
        }
        if (!(condPushFrom instanceof InstanceOf)) {
            return;
        }
        InstanceOf instanceOf = (InstanceOf)condPushFrom;
        if (!cast.getType().equals(instanceOf.getType())) {
            return;
        }
        Load load = LoadStoreMatching.matchLoadLocal(cast.getArgument());
        if (!(load instanceof Load)) {
            return;
        }
        Load castLoad = load;
        if (LoadStoreMatching.matchLoadLocal(LoadStoreMatching.matchPushForPop(instanceOf.getArgument()), castLoad.getVariable()) == null) {
            return;
        }
        ControlFlowGraph cfg = this.ctx.getControlFlowGraph();
        ControlFlowNode head = cfg.getNode(trueBlock);
        if (!ColUtils.allMatch(variable.getReferences(), i -> !i.isWrittenTo() || cfg.dominates(head, (Instruction)i))) {
            return;
        }
        this.ctx.pushStep("Inline Instanceof pattern");
        instanceOf.setPattern((LocalReference)store2.getReference());
        store2.remove();
        Instruction instruction3 = trueBlock.getFirstChild();
        if (instruction3 instanceof Branch) {
            Branch br = (Branch)instruction3;
            if (br.getTargetBlock() != ifInsn.getParent().getNextSiblingOrNull()) {
                this.invertIf(ifInsn);
            }
        } else if (trueBlock.getFirstChild() instanceof Leave) {
            this.invertIf(ifInsn);
        }
        this.ctx.popStep();
    }

    public static boolean inlineExitBranch(Block block, BlockTransformContext ctx) {
        Instruction exitInsn = ConditionDetection.getExit(block);
        if (!ConditionDetection.canInline(exitInsn)) {
            return false;
        }
        ctx.pushStep("Inline exit-branch");
        Block targetBlock = ((Branch)exitInsn).getTargetBlock();
        ((Instruction)block.instructions.last()).remove();
        block.instructions.addAll((Iterable<Instruction>)((Object)targetBlock.instructions));
        targetBlock.remove();
        ctx.popStep();
        return true;
    }

    private static boolean canInline(Instruction exitInsn) {
        if (!(exitInsn instanceof Branch)) {
            return false;
        }
        Branch branch = (Branch)exitInsn;
        Block targetBlock = branch.getTargetBlock();
        if (targetBlock.getIncomingEdgeCount() != 1) {
            return false;
        }
        Block parentBlock = (Block)exitInsn.ancestorsOfType(Block.class).filter(b -> b.getParent() instanceof BlockContainer).first();
        return parentBlock.getNextSiblingOrNull() == targetBlock;
    }

    private void mergeExitsForInline(Block block, IfInstruction ifInsn) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Block nextBlock = (Block)block.getNextSiblingOrNull();
        if (nextBlock == null) {
            return;
        }
        if (!nextBlock.getBranches().allMatch(b -> b.isDescendantOf(block))) {
            return;
        }
        this.moveBranchExitsTowardsRoot(block, nextBlock);
        ConditionDetection.inlineExitBranch(block, this.ctx);
    }

    private void moveBranchExitsTowardsRoot(Block block, Block targetBlock) {
        if (!block.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            return;
        }
        for (Instruction insn = block.getLastChild(); insn != null; insn = insn.getPrevSiblingOrNull()) {
            Branch trueExit;
            IfInstruction ifInsn = IfMatching.matchNopFalseIf(insn);
            if (ifInsn == null) continue;
            Instruction instruction = ifInsn.getTrueInsn();
            if (instruction instanceof Block) {
                Block trueBlock = (Block)instruction;
                this.moveBranchExitsTowardsRoot(trueBlock, targetBlock);
            }
            if ((trueExit = BranchLeaveMatching.matchBranch(ConditionDetection.tryGetExit(ifInsn.getTrueInsn()), targetBlock)) == null) continue;
            if (BranchLeaveMatching.compatibleExitInstruction(ConditionDetection.tryGetExit(block), trueExit)) {
                this.mergeTrueExitWithFallthrough(block, ifInsn);
                continue;
            }
            this.moveTrueExitToFallthrough(block, ifInsn);
        }
    }

    private void moveTrueExitToFallthrough(Block block, IfInstruction ifInsn) {
        this.ctx.pushStep("Move true exit to fallthrough");
        this.ctx.pushStep("Introduce else");
        ifInsn.setFalseInsn(block.extractRange(ifInsn.getNextSibling(), block.getLastChild()));
        this.ctx.popStep();
        Instruction exit = ConditionDetection.getExit(ifInsn.getTrueInsn());
        ConditionDetection.ensureParentIsBlock(exit);
        block.instructions.add(exit);
        this.ctx.popStep();
    }

    private void tryMergeTrueExitWithFallthrough(Block block, IfInstruction ifInsn) {
        Instruction exit;
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Instruction trueExit = ConditionDetection.tryGetExit(ifInsn.getTrueInsn());
        if (BranchLeaveMatching.compatibleExitInstruction(trueExit, exit = ConditionDetection.tryGetExit(block))) {
            this.mergeTrueExitWithFallthrough(block, ifInsn);
        }
    }

    private void mergeTrueExitWithFallthrough(Block block, IfInstruction ifInsn) {
        this.ctx.pushStep("Merge true exit with fallthrough");
        if (ifInsn != block.instructions.secondToLastOrDefault()) {
            assert (ifInsn.getFalseInsn() instanceof Nop);
            this.ctx.pushStep("Introduce else");
            ifInsn.setFalseInsn(block.extractRange(ifInsn.getNextSibling(), block.getLastChild().getPrevSibling()));
            this.ctx.popStep();
        }
        Instruction exit = ConditionDetection.getExit(ifInsn.getTrueInsn());
        ConditionDetection.ensureParentIsBlock(exit);
        exit.remove();
        this.ctx.popStep();
    }

    private boolean prepareShortCircuitOr(IfInstruction ifInsn) {
        Block trueBlock;
        Instruction instruction = ifInsn.getNextSibling();
        if (!(instruction instanceof Branch)) {
            return false;
        }
        Branch elseBranch = (Branch)instruction;
        Instruction instruction2 = ifInsn.getTrueInsn();
        if (!(instruction2 instanceof Block) || ConditionDetection.tryGetExit(trueBlock = (Block)instruction2) == null) {
            return false;
        }
        IfInstruction trueIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (trueIf == null || BranchLeaveMatching.matchBranch(trueIf.getTrueInsn(), elseBranch.getTargetBlock()) == null) {
            return false;
        }
        this.ctx.pushStep("Prepare short-circuit or");
        this.invertIf(trueIf);
        this.ctx.popStep();
        return true;
    }

    private void introduceShortCircuit(IfInstruction ifInsn) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return;
        }
        Block trueBlock = (Block)instruction;
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        IfInstruction nestedIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (nestedIf == null) {
            return;
        }
        if (nestedIf.getNextSiblingOrNull() != null) {
            return;
        }
        if (this.isAssertion(nestedIf)) {
            return;
        }
        this.ctx.pushStep("Introduce short-circuit");
        extraTransforms.forEach(Runnable::run);
        ifInsn.setCondition(new LogicAnd(ifInsn.getCondition(), nestedIf.getCondition()));
        ifInsn.setTrueInsn(nestedIf.getTrueInsn());
        ExpressionTransforms.runOnExpression(ifInsn.getCondition(), this.ctx);
        this.ctx.popStep();
    }

    private boolean isAssertion(IfInstruction ifInsn) {
        Instruction instruction = ifInsn.getCondition();
        if (!(instruction instanceof LogicAnd)) {
            return false;
        }
        LogicAnd and = (LogicAnd)instruction;
        Instruction instruction2 = and.getLeft();
        if (!(instruction2 instanceof LogicNot)) {
            return false;
        }
        LogicNot not = (LogicNot)instruction2;
        Load load = LoadStoreMatching.matchLoadField(not.getArgument());
        if (load == null) {
            return false;
        }
        Field field = ((FieldReference)load.getReference()).getField();
        return field.isSynthetic() && field.getName().equals("$assertionsDisabled");
    }

    private void produceTernary(IfInstruction ifInsn) {
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return;
        }
        Block trueBlock = (Block)instruction;
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        IfInstruction thenIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (thenIf == null || thenIf.getNextSiblingOrNull() != null) {
            return;
        }
        Instruction instruction2 = ifInsn.getFalseInsn();
        if (!(instruction2 instanceof Block)) {
            return;
        }
        Block falseBlock = (Block)instruction2;
        IfInstruction elseIf = Inlining.matchWithPotentialInline(falseBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (elseIf == null || elseIf.getNextSiblingOrNull() != null) {
            return;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getTrueInsn(), elseIf.getTrueInsn())) {
            return;
        }
        this.ctx.pushStep("Produce ternary");
        extraTransforms.forEach(Runnable::run);
        ifInsn.setCondition(new Ternary(ifInsn.getCondition(), thenIf.getCondition(), elseIf.getCondition()));
        ifInsn.setTrueInsn((Instruction)FastStream.of((Object[])new Instruction[]{thenIf.getTrueInsn(), elseIf.getTrueInsn()}).maxBy(Instruction::getBytecodeOffset));
        ifInsn.setFalseInsn(new Nop());
        this.ctx.popStep();
    }

    private void invertIf(IfInstruction ifInsn) {
        ConditionDetection.invertIf(ifInsn, this.ctx);
    }

    public static void invertIf(IfInstruction ifInsn, MethodTransformContext ctx) {
        Instruction thenInsn;
        Block block = (Block)ifInsn.getParent();
        ctx.pushStep("Invert if");
        assert (ifInsn.getParentOrNull() == block);
        assert (ifInsn.getFalseInsn() instanceof Nop);
        ConditionDetection.getExit(ifInsn.getTrueInsn());
        Instruction elseInsn = ConditionDetection.getExit(block);
        if (ifInsn.getNextSibling() != elseInsn) {
            elseInsn = block.extractRange(ifInsn.getNextSibling(), elseInsn);
        }
        if ((thenInsn = ifInsn.getTrueInsn()) instanceof Block) {
            Block thenBlock = (Block)thenInsn;
            block.instructions.addAll((Iterable<Instruction>)((Object)thenBlock.instructions));
        } else {
            block.instructions.add(thenInsn);
        }
        ifInsn.setTrueInsn(elseInsn);
        ifInsn.setCondition(new LogicNot(ifInsn.getCondition()));
        ExpressionTransforms.runOnExpression(ifInsn.getCondition(), ctx);
        ctx.popStep();
    }

    private static void ensureParentIsBlock(Instruction insn) {
        if (insn.getParent() instanceof Block) {
            return;
        }
        Block b = new Block();
        b.instructions.add(insn);
        insn.replaceWith(b);
    }

    @Nullable
    private static Instruction tryGetExit(@Nullable Instruction insn) {
        Instruction exitInsn = insn;
        if (insn instanceof Block) {
            exitInsn = insn.getLastChildOrNull();
        }
        if (exitInsn != null && exitInsn.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            return exitInsn;
        }
        return null;
    }

    private static Instruction getExit(Instruction insn) {
        return Objects.requireNonNull(ConditionDetection.tryGetExit(insn));
    }
}

