/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayLen;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class LoadStoreMatching {
    @Nullable
    public static Store matchStoreLocalLoadLocal(@Nullable Instruction insn, LocalVariable variable) {
        Store store = LoadStoreMatching.matchStoreLocal(insn);
        if (store == null) {
            return null;
        }
        Load load = LoadStoreMatching.matchLoadLocal(store.getValue(), variable);
        if (load == null) {
            return null;
        }
        return store;
    }

    @Nullable
    public static LocalReference matchLocalRef(@Nullable Instruction insn, LocalVariable variable) {
        LocalReference localRef;
        block3: {
            block2: {
                if (!(insn instanceof LocalReference)) break block2;
                localRef = (LocalReference)insn;
                if (localRef.variable == variable) break block3;
            }
            return null;
        }
        return localRef;
    }

    @Nullable
    @Contract(value="null->null")
    public static Load matchLoadLocal(@Nullable Instruction insn) {
        Load load;
        if (!(insn instanceof Load) || !((load = (Load)insn).getReference() instanceof LocalReference)) {
            return null;
        }
        return load;
    }

    @Nullable
    public static Load matchLoadLocal(@Nullable Instruction insn, LocalVariable variable) {
        Load load = LoadStoreMatching.matchLoadLocal(insn);
        if (load == null) {
            return null;
        }
        if (load.getVariable() != variable) {
            return null;
        }
        return load;
    }

    @Nullable
    public static Store matchStoreLocal(@Nullable Instruction insn) {
        Store store;
        if (!(insn instanceof Store) || !((store = (Store)insn).getReference() instanceof LocalReference)) {
            return null;
        }
        return store;
    }

    @Nullable
    public static Store matchStoreLocal(@Nullable Instruction insn, LocalVariable variable) {
        Store store = LoadStoreMatching.matchStoreLocal(insn);
        if (store == null) {
            return null;
        }
        if (store.getVariable() != variable) {
            return null;
        }
        return store;
    }

    @Nullable
    public static FieldReference matchFieldRef(@Nullable Instruction insn, Field field) {
        if (!(insn instanceof FieldReference)) {
            return null;
        }
        FieldReference fieldRef = (FieldReference)insn;
        if (!LoadStoreMatching.matchField(fieldRef.getField(), field)) {
            return null;
        }
        return fieldRef;
    }

    @Nullable
    public static Load matchLoadField(@Nullable Instruction insn) {
        if (!(insn instanceof Load)) {
            return null;
        }
        Load load = (Load)insn;
        if (!(load.getReference() instanceof FieldReference)) {
            return null;
        }
        return load;
    }

    @Nullable
    public static Load matchLoadField(@Nullable Instruction insn, Field field) {
        if (!(insn instanceof Load)) {
            return null;
        }
        Load load = (Load)insn;
        if (LoadStoreMatching.matchFieldRef(load.getReference(), field) == null) {
            return null;
        }
        return load;
    }

    @Nullable
    public static FieldReference matchLoadFieldRef(@Nullable Instruction insn) {
        if (!(insn instanceof Load)) {
            return null;
        }
        Load load = (Load)insn;
        Reference reference = load.getReference();
        if (!(reference instanceof FieldReference)) {
            return null;
        }
        FieldReference fieldRef = (FieldReference)reference;
        return fieldRef;
    }

    @Nullable
    public static FieldReference matchStoreFieldRef(@Nullable Instruction insn) {
        if (!(insn instanceof Store)) {
            return null;
        }
        Store store = (Store)insn;
        Reference reference = store.getReference();
        if (!(reference instanceof FieldReference)) {
            return null;
        }
        FieldReference fieldRef = (FieldReference)reference;
        return fieldRef;
    }

    @Nullable
    public static Store matchStoreField(@Nullable Instruction insn) {
        Store store;
        if (!(insn instanceof Store) || !((store = (Store)insn).getReference() instanceof FieldReference)) {
            return null;
        }
        return store;
    }

    @Nullable
    @Contract(value="null,_->null")
    public static Store matchStoreField(@Nullable Instruction insn, Field field) {
        if (!(insn instanceof Store)) {
            return null;
        }
        Store store = (Store)insn;
        if (LoadStoreMatching.matchFieldRef(store.getReference(), field) == null) {
            return null;
        }
        return store;
    }

    public static boolean matchField(Field field1, Field field2) {
        return field1.getName().equals(field2.getName()) && field1.getDescriptor().equals((Object)field2.getDescriptor()) && (field1.getDeclaringClass().equals(field2.getDeclaringClass()) || field1.equals(field2));
    }

    public static boolean equivalentFieldDescriptors(Field field1, Field field2) {
        return field1.getName().equals(field2.getName()) && field1.getDescriptor().equals((Object)field2.getDescriptor()) && field1.getDeclaringClass().equals(field2.getDeclaringClass());
    }

    @Nullable
    public static ArrayLen matchArrayLenLoad(@Nullable Instruction insn, LocalVariable loadVar) {
        if (!(insn instanceof ArrayLen)) {
            return null;
        }
        ArrayLen arrayLen = (ArrayLen)insn;
        Load load = LoadStoreMatching.matchLoadLocal(arrayLen.getArray(), loadVar);
        if (load == null) {
            return null;
        }
        return arrayLen;
    }

    @Nullable
    public static ArrayElementReference matchLoadElemRef(@Nullable Instruction insn) {
        if (!(insn instanceof Load)) {
            return null;
        }
        Load load = (Load)insn;
        Reference reference = load.getReference();
        if (!(reference instanceof ArrayElementReference)) {
            return null;
        }
        ArrayElementReference arrayRef = (ArrayElementReference)reference;
        return arrayRef;
    }

    @Nullable
    public static Instruction matchPushForPop(@Nullable Instruction insn) {
        Load load = LoadStoreMatching.matchLoadLocal(insn);
        if (!(load instanceof Load)) {
            return null;
        }
        Load load2 = load;
        LocalVariable variable = load2.getVariable();
        if (variable.getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return null;
        }
        if (variable.getStoreCount() != 1) {
            return null;
        }
        Store store = (Store)FastStream.of(variable.getReferences()).map(e -> LoadStoreMatching.matchStoreLocal(e.getParent())).filter(Objects::nonNull).onlyOrDefault();
        if (store == null) {
            return null;
        }
        return store.getValue();
    }
}

