/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.debug.DebugStepper;
import net.covers1624.coffeegrinder.debug.Stepper;
import org.jetbrains.annotations.Nullable;

public class Step
implements AutoCloseable {
    private final DebugStepper stepper;
    private final int id;
    private final StepType type;
    private final StepContextType contextType;
    private final String name;
    private Status status = Status.SUCCESS;
    @Nullable
    Throwable exception;
    @Nullable
    private final Step parent;
    final LinkedList<Step> children = new LinkedList();
    @Nullable
    final Stepper.ContextSupplier supplier;
    private final String preStepContent;
    private final long startTime;
    @Nullable
    private String postStepContent = "NO CONTENT";
    private long endTime;
    boolean isFinished;

    Step(DebugStepper stepper, int id, String name, Step parent, String preContent, String postContent, long startTime, long endTime) {
        this.stepper = stepper;
        this.id = id;
        this.type = StepType.CONTENT;
        this.contextType = StepContextType.NONE;
        this.name = name;
        this.parent = parent;
        this.supplier = null;
        this.preStepContent = preContent;
        this.postStepContent = postContent;
        this.startTime = startTime;
        this.endTime = endTime;
        this.isFinished = true;
    }

    Step(DebugStepper stepper, int id, StepType type, StepContextType contextType, String name, @Nullable Step parent, @Nullable String preContent, @Nullable Stepper.ContextSupplier supplier) {
        this.stepper = stepper;
        this.id = id;
        this.type = type;
        this.contextType = contextType;
        this.name = name;
        this.parent = parent;
        this.supplier = supplier;
        this.preStepContent = preContent != null ? preContent : (supplier != null ? supplier.print(stepper.getOpts()) : "NO CONTENT");
        this.startTime = System.nanoTime();
    }

    boolean finish() {
        Throwable ex = this.stepper.clearExcept();
        if (ex != null) {
            this.propagateThrowable(ex);
            return false;
        }
        if (this.supplier != null) {
            try {
                this.postStepContent = this.supplier.print(this.stepper.getOpts());
            }
            catch (Throwable e) {
                if (this.status == Status.ERROR) {
                    StringWriter writer = new StringWriter();
                    e.printStackTrace(new PrintWriter(writer));
                    writer.flush();
                    this.postStepContent = "Exception was thrown whilst printing in error state.\n" + String.valueOf(writer);
                }
                throw e;
            }
        }
        this.endTime = System.nanoTime();
        this.isFinished = true;
        return true;
    }

    private void propagateThrowable(Throwable ex) {
        boolean handled = false;
        for (Step child : this.children) {
            if (child.isFinished) continue;
            handled = true;
            child.propagateThrowable(ex);
            break;
        }
        if (!handled) {
            this.exception = ex;
        }
        this.status = Status.ERROR;
        this.stepper.popStep();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public StepType getType() {
        return this.type;
    }

    public StepContextType getContextType() {
        return this.contextType;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Throwable getCaughtException() {
        return this.exception;
    }

    @Nullable
    public Step getParent() {
        return this.parent;
    }

    public List<Step> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Nullable
    public String getPreStepContent() {
        return this.preStepContent;
    }

    @Nullable
    public String getPostStepContent() {
        return this.postStepContent;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    @Override
    public void close() {
        this.stepper.popStep();
    }

    public static enum Status {
        SUCCESS,
        ERROR;

    }

    public static enum StepType {
        CONTENT,
        TIMING;

    }

    public static enum StepContextType {
        NONE,
        CLASS,
        METHOD,
        TRANSFORMER;

    }
}

