/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.debug;

import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.source.JavaSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.type.TypeResolver;
import org.jetbrains.annotations.Nullable;

public interface Stepper {
    public DebugPrintOptions getOpts();

    public void pushContext(ContextSupplier var1);

    public void popContext();

    @Nullable
    public Step pushStep(String var1);

    @Nullable
    public Step pushStep(String var1, Step.StepContextType var2);

    @Nullable
    public Step pushStepWithContent(String var1, Step.StepContextType var2, Supplier<String> var3);

    public void popStep();

    @Nullable
    public Step pushTiming(String var1);

    public void popTiming();

    public void except(Throwable var1);

    @Nullable
    public Step getRoot();

    public static interface ContextSupplier {
        public String print(DebugPrintOptions var1);

        public static ContextSupplier ofInsn(TypeResolver resolver, Instruction insn) {
            return options -> {
                if (!options.javaSource()) {
                    return insn.toString(options);
                }
                JavaSourceVisitor visitor = new JavaSourceVisitor(resolver, options.showImplicits());
                LineBuffer text = visitor.lines(insn);
                return String.join((CharSequence)"\n", text.lines);
            };
        }
    }
}

