/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Appendable;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Context;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Factory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class Element<T extends Element<T>>
implements Appendable<T> {
    private static final Pattern CDATA_SPLIT_PATTERN = Pattern.compile("(?<=]])(?=>)");
    static final String CDATA_WORKAROUND_COMMENT = "CDATA-WORKAROUND-" + UUID.randomUUID();
    private final Context context;
    private final Namespace namespace;
    final org.w3c.dom.Element domElement;

    public Element(Context context, QualifiedName qualifiedName) {
        this.context = context;
        this.namespace = qualifiedName.getNamespace();
        this.domElement = context.createElement(qualifiedName);
    }

    org.w3c.dom.Element getDomElement() {
        return this.domElement;
    }

    public Element<T> withContent(String value) {
        this.domElement.setTextContent(value);
        return this;
    }

    public Element<T> withCDataSection(String value) {
        String[] parts = CDATA_SPLIT_PATTERN.split(value);
        this.domElement.appendChild(this.document().createCDATASection(parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            this.domElement.appendChild(this.document().createComment(CDATA_WORKAROUND_COMMENT));
            this.domElement.appendChild(this.document().createCDATASection(parts[i]));
        }
        return this;
    }

    public Element<T> withAttribute(QualifiedName qualifiedName, String value) {
        Attr attr = this.createAttr(qualifiedName);
        attr.setValue(value);
        this.domElement.setAttributeNode(attr);
        return this;
    }

    private Attr createAttr(QualifiedName qualifiedName) {
        return this.namespace.equals(qualifiedName.getNamespace()) ? this.document().createAttribute(qualifiedName.getSimpleName()) : this.document().createAttributeNS(qualifiedName.getNamespace().getUri(), this.context.prefixed(qualifiedName));
    }

    private Document document() {
        return this.context.getDocument();
    }

    @Override
    public <C extends ChildElement<T, ? super C>> Appendable<T> append(Factory<C> creator, Consumer<? super C> configurer) {
        ChildElement child = (ChildElement)creator.createAndConfigure(this.context, configurer);
        this.domElement.appendChild(child.domElement);
        return this;
    }

    public String toString() {
        return "Element{domElement=" + this.domElement + '}';
    }
}

