/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.IIncTag;
import net.covers1624.coffeegrinder.bytecode.insns.tags.InsnTag;
import net.covers1624.coffeegrinder.bytecode.insns.tags.PotentialConstantLookupTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Inlining
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null) {
            return;
        }
        LocalVariable v = store.getVariable();
        if (v.getStoreCount() != 1) {
            return;
        }
        if (!Inlining.isKnownSyntheticVariable(v)) {
            return;
        }
        if (v.getLoadCount() == 0 && v.getKind() == LocalVariable.VariableKind.STACK_SLOT) {
            ctx.pushStep("Remove redundant stack store " + v.getUniqueName());
            store.replaceWith(store.getValue());
            ctx.popStep();
            return;
        }
        if (v.getLoadCount() != 1) {
            return;
        }
        Instruction inlinedExpression = store.getValue();
        Load inlineTarget = (Load)((LocalReference)FastStream.of(v.getReferences()).filter(Reference::isReadFrom).only()).getParent();
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        if (v.getKind() == LocalVariable.VariableKind.STACK_SLOT ? Inlining.matchWithPotentialInline(store.getNextSiblingOrNull(), extraTransforms, ctx, e -> this.matchLoadIn((Instruction)e, inlineTarget)) == null : !this.loadIsFirstOpIn(store.getNextSiblingOrNull(), inlineTarget)) {
            return;
        }
        ctx.pushStep("Inline variable " + v.getUniqueName());
        extraTransforms.forEach(Runnable::run);
        inlinedExpression.setOffsets(inlineTarget);
        inlinedExpression.setOffsets(store);
        inlineTarget.replaceWith(inlinedExpression);
        store.remove();
        this.insertCastForIntegerConstantIfNecessary(inlinedExpression, v.getType(), ctx);
        this.unwrapStringValueOf(inlinedExpression, ctx);
        ctx.popStep();
    }

    private void insertCastForIntegerConstantIfNecessary(Instruction expr, AType type, StatementTransformContext ctx) {
        if (expr.getParent() instanceof Store) {
            return;
        }
        if (!(expr.getResultType() instanceof IntegerConstantType) || TypeSystem.isAssignableTo(PrimitiveType.INT, type)) {
            return;
        }
        ctx.pushStep("Add cast");
        expr.replaceWith(new Cast(expr, type));
        ctx.popStep();
    }

    private void unwrapStringValueOf(Instruction expr, StatementTransformContext ctx) {
        Invoke valueOf = InvokeMatching.matchInvoke(expr, Invoke.InvokeKind.STATIC, "valueOf");
        if (valueOf == null) {
            return;
        }
        if (!TypeSystem.isString(valueOf.getMethod().getDeclaringClass())) {
            return;
        }
        Binary binary = Inlining.matchBinaryAdd(valueOf.getParent());
        if (binary == null) {
            return;
        }
        ctx.pushStep("Unwrap String.valueOf in string concat.");
        valueOf.replaceWith(valueOf.getArguments().get(0));
        if (!TypeSystem.isString(binary.getLeft().getResultType()) && !TypeSystem.isString(binary.getRight().getResultType())) {
            ctx.pushStep("Add empty string constant to coerce concat of non-strings");
            ClassType string = ctx.getTypeResolver().resolveClassDecl(TypeResolver.STRING_TYPE);
            binary.getLeft().replaceWith(new Binary(BinaryOp.ADD, new LdcString(string, ""), binary.getLeft()));
            ctx.popStep();
        }
        ctx.popStep();
    }

    @Contract(value="null->null")
    @Nullable
    private static Binary matchBinaryAdd(@Nullable Instruction insn) {
        if (!(insn instanceof Binary)) {
            return null;
        }
        Binary binary = (Binary)insn;
        if (binary.getOp() != BinaryOp.ADD) {
            return null;
        }
        return binary;
    }

    private boolean loadIsFirstOpIn(@Nullable Instruction e, Load inlineTarget) {
        InstanceOf instanceOf;
        CompoundAssignment assignment;
        FieldReference fieldRef;
        Return ret;
        Instruction instruction = inlineTarget.getParent();
        if (instruction instanceof Return && (ret = (Return)instruction) == e) {
            return true;
        }
        Instruction instruction2 = inlineTarget.getParent();
        if (instruction2 instanceof FieldReference && (instruction2 = (fieldRef = (FieldReference)instruction2).getParent()) instanceof CompoundAssignment && (assignment = (CompoundAssignment)instruction2) == e) {
            return true;
        }
        instruction = inlineTarget.getParent();
        return instruction instanceof InstanceOf && !((instanceOf = (InstanceOf)instruction).getPattern() instanceof Nop);
    }

    @Nullable
    private Instruction matchLoadIn(Instruction e, Load inlineTarget) {
        return inlineTarget.isDescendantOf(e) ? e : null;
    }

    private static boolean isKnownSyntheticVariable(LocalVariable var) {
        return var.isSynthetic() || var.getName().startsWith("patt") && var.getName().endsWith("$temp");
    }

    @Nullable
    public static <T> T matchWithPotentialInline(@Nullable Instruction insn, List<Runnable> extraTransforms, MethodTransformContext ctx, Function<Instruction, @Nullable T> matcher) {
        if (insn == null) {
            return null;
        }
        T matched = matcher.apply(insn);
        if (matched != null) {
            return matched;
        }
        if (!Inlining.canInlineIfRequired(insn, extraTransforms, ctx)) {
            return null;
        }
        return matcher.apply(insn.getNextSiblingOrNull());
    }

    public static boolean canInlineIfRequired(Instruction expr, List<Runnable> extraInliningTasks, MethodTransformContext ctx) {
        if (expr.getNextSiblingOrNull() == null) {
            return false;
        }
        if (Inlining.canInlineIInc(expr, extraInliningTasks, ctx)) {
            return true;
        }
        return Inlining.canInlinePotentialConstantLookup(expr, extraInliningTasks, ctx);
    }

    private static boolean canInlineIInc(Instruction expr, List<Runnable> extraInliningTasks, MethodTransformContext ctx) {
        if (!(expr.getTag() instanceof IIncTag)) {
            return false;
        }
        Load potentialInline = ((IIncTag)expr.getTag()).potentialInline;
        if (potentialInline == null) {
            return false;
        }
        extraInliningTasks.add(() -> {
            ctx.pushStep("Inline iinc");
            potentialInline.replaceWith(expr);
            ctx.popStep();
        });
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canInlinePotentialConstantLookup(Instruction expr, List<Runnable> extraInliningTasks, MethodTransformContext ctx) {
        Invoke invoke;
        LdcInsn ldcInsn;
        boolean isStatic;
        InsnTag insnTag = expr.getTag();
        if (!(insnTag instanceof PotentialConstantLookupTag)) return false;
        PotentialConstantLookupTag potentialConstantLookupTag = (PotentialConstantLookupTag)insnTag;
        try {
            boolean bl;
            isStatic = bl = potentialConstantLookupTag.isStatic();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        LdcInsn ldc = ldcInsn = potentialConstantLookupTag.ldc();
        Object ldcValue = Objects.requireNonNull(ldc.getRawValue());
        Instruction target = isStatic ? expr : ((invoke = (Invoke)expr).getKind() == Invoke.InvokeKind.STATIC ? (Instruction)invoke.getArguments().first() : ((Invoke)expr).getTarget());
        Field constantField = ((ClassType)target.getResultType()).findConstant(ldcValue, isStatic);
        if (constantField == null) {
            expr.setTag(null);
            return false;
        }
        assert (ldc.isConnected());
        extraInliningTasks.add(() -> {
            ctx.pushStep("Inline constant lookup");
            ldc.replaceWith(new Load(new FieldReference(constantField, target)));
            if (expr != target) {
                expr.remove();
            }
            ctx.popStep();
        });
        return true;
    }
}

