/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.Iterator;
import java.util.List;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayLen;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Continue;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.Yield;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.GenericTransform;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.IntegerConstantUnion;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ParameterizedMethod;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;

public class InvariantVisitor
extends SimpleInsnVisitor<None> {
    private static final EnumBitSet<AccessFlag> LOAD_FLAG_MASK = EnumBitSet.of((Enum[])new AccessFlag[]{AccessFlag.STATIC, AccessFlag.FINAL});
    private static final AType BOOLEAN_CONSTANTS = new IntegerConstantUnion(List.of(new IntegerConstantType(0), new IntegerConstantType(1)));

    public static void checkInvariants(Instruction insn) {
        if (!DecompilerSettings.ASSERTIONS_ENABLED) {
            return;
        }
        insn.accept(new InvariantVisitor());
    }

    @Override
    public None visitDefault(Instruction insn, None ctx) {
        super.visitDefault(insn, ctx);
        InstructionSlot<?> slot = insn.firstChild;
        while (slot != null) {
            slot.checkInvariant();
            slot = slot.nextSibling;
        }
        return NONE;
    }

    @Override
    public None visitArrayElementReference(ArrayElementReference elemRef, None ctx) {
        assert (elemRef.getArray().getResultType() instanceof ArrayType);
        assert (TypeSystem.isAssignableTo(elemRef.getIndex().getResultType(), PrimitiveType.INT));
        return (None)super.visitArrayElementReference(elemRef, ctx);
    }

    @Override
    public None visitArrayLen(ArrayLen arrayLen, None ctx) {
        assert (arrayLen.getArray().getResultType() instanceof ArrayType);
        return (None)super.visitArrayLen(arrayLen, ctx);
    }

    @Override
    public None visitBlock(Block block, None ctx) {
        if (block.getParent() instanceof BlockContainer) {
            assert (block.getIncomingEdgeCount() > 0) : "Unreachable block: " + block.getName();
        } else assert (block.getIncomingEdgeCount() == 0) : "Block should not have any edges: " + block.getName();
        Iterator<Instruction> iterator = block.instructions.iterator();
        while (iterator.hasNext()) {
            Instruction insn = iterator.next();
            assert (!insn.hasFlag(InstructionFlag.END_POINT_UNREACHABLE) || insn == block.getLastChild());
        }
        return (None)super.visitBlock(block, ctx);
    }

    @Override
    public None visitBlockContainer(BlockContainer container, None ctx) {
        assert (!container.blocks.isEmpty() && container.getEntryPoint() == container.blocks.first());
        assert (!container.isConnected() || container.getEntryPoint().getIncomingEdgeCount() >= 1);
        assert (FastStream.of(container.blocks).allMatch(e -> e.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)));
        return (None)super.visitBlockContainer(container, ctx);
    }

    @Override
    public None visitBranch(Branch branch, None ctx) {
        assert (branch.getTargetBlock().getParentOrNull() instanceof BlockContainer);
        assert (branch.isDescendantOf(branch.getTargetBlock().getParentOrNull()));
        return (None)super.visitBranch(branch, ctx);
    }

    @Override
    public None visitCheckCast(Cast cast, None ctx) {
        AType argType = cast.getArgument().getResultType();
        if (cast.getType() instanceof ReferenceType && argType instanceof ReferenceType) assert (this.isCastableTo((ReferenceType)argType, (ReferenceType)cast.getType()));
        InvariantVisitor.assertRepresentable(cast, cast.getType());
        return (None)super.visitCheckCast(cast, ctx);
    }

    private static void assertRepresentable(Instruction scope, AType type) {
        assert (GenericTransform.isRepresentable(scope, type)) : "Unable to represent: " + String.valueOf(type);
    }

    @Override
    public None visitContinue(Continue cont, None ctx) {
        assert (cont.getLoop().isConnected());
        return (None)super.visitContinue(cont, ctx);
    }

    @Override
    public None visitFieldDecl(FieldDecl fieldDecl, None ctx) {
        assert (fieldDecl.getParent() instanceof ClassDecl);
        return (None)super.visitFieldDecl(fieldDecl, ctx);
    }

    @Override
    public None visitIfInstruction(IfInstruction ifInsn, None ctx) {
        assert (this.isAssignableTo(ifInsn.getCondition().getResultType(), PrimitiveType.BOOLEAN));
        InvariantVisitor.assertIfSide(ifInsn.getTrueInsn());
        InvariantVisitor.assertIfSide(ifInsn.getFalseInsn());
        return (None)super.visitIfInstruction(ifInsn, ctx);
    }

    private static void assertIfSide(Instruction insn) {
        if (insn instanceof Block) {
            Block block = (Block)insn;
            assert (block.instructions.isEmpty() || Block.requiresBlock(block.getFirstChild()));
        } else assert (!Block.requiresBlock(insn));
    }

    @Override
    public None visitLocalVariable(LocalVariable localVariable, None ctx) {
        assert (!localVariable.isDead());
        if (localVariable.getKind() == LocalVariable.VariableKind.PARAMETER) {
            ParameterVariable p = (ParameterVariable)localVariable;
            assert (!p.isImplicit() || p.getReferenceCount() == 0);
        } else assert (localVariable.getStoreCount() > 0);
        return (None)super.visitLocalVariable(localVariable, ctx);
    }

    @Override
    public None visitInvoke(Invoke invoke, None ctx) {
        List<Parameter> parameters = invoke.getMethod().getParameters();
        assert (parameters.size() == invoke.getArguments().size());
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            Instruction arg = invoke.getArguments().get(i);
            assert (arg instanceof Nop || this.isAssignableTo(arg.getResultType(), parameter.getType()));
        }
        if (invoke.explicitTypeArgs) {
            ((ParameterizedMethod)invoke.getMethod()).getTypeArguments().forEach(type -> InvariantVisitor.assertRepresentable(invoke, type));
        }
        assert (TypeSystem.isFullyDefined(invoke.getMethod()));
        return (None)super.visitInvoke(invoke, ctx);
    }

    @Override
    public None visitLeave(Leave leave, None ctx) {
        assert (leave.isDescendantOf(leave.getTargetContainer()));
        return (None)super.visitLeave(leave, ctx);
    }

    @Override
    public None visitLocalReference(LocalReference localRef, None ctx) {
        assert (localRef.variable.isConnected());
        return (None)super.visitLocalReference(localRef, ctx);
    }

    @Override
    public None visitNew(New newInsn, None ctx) {
        List<Parameter> parameters = newInsn.getMethod().getParameters();
        assert (parameters.size() == newInsn.getArguments().size());
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            Instruction arg = newInsn.getArguments().get(i);
            assert (arg instanceof Nop || this.isAssignableTo(arg.getResultType(), parameter.getType()));
        }
        if (newInsn.explicitTypeArgs) {
            ((ParameterizedMethod)newInsn.getMethod()).getTypeArguments().forEach(type -> InvariantVisitor.assertRepresentable(newInsn, type));
        }
        if (newInsn.explicitClassTypeArgs) {
            ((ParameterizedClass)newInsn.getResultType()).getTypeArguments().forEach(type -> InvariantVisitor.assertRepresentable(newInsn, type));
        }
        assert (TypeSystem.isFullyDefined(newInsn.getResultType()));
        assert (TypeSystem.isFullyDefined(newInsn.getMethod()));
        return (None)super.visitNew(newInsn, ctx);
    }

    @Override
    public None visitReturn(Return ret, None ctx) {
        assert (this.isAssignableTo(ret.getValue().getResultType(), ret.getMethod().getReturnType()));
        assert (ret.getMethod().getReturns().contains(ret));
        assert (ret.firstAncestorOfType(MethodDecl.class) == ret.getMethod());
        return (None)super.visitReturn(ret, ctx);
    }

    @Override
    public None visitStore(Store store, None ctx) {
        assert (this.isAssignableTo(store.getValue().getResultType(), store.getReference().getType()));
        return (None)super.visitStore(store, ctx);
    }

    @Override
    public None visitSwitch(Switch switchInsn, None ctx) {
        switchInsn.getSwitchTable();
        assert (switchInsn.getYields().isEmpty() == (switchInsn.getResultType() == PrimitiveType.VOID));
        return (None)super.visitSwitch(switchInsn, ctx);
    }

    @Override
    public None visitSwitchTable(SwitchTable switchTable, None ctx) {
        boolean hasDefault = false;
        Iterator<SwitchTable.SwitchSection> iterator = switchTable.sections.iterator();
        while (iterator.hasNext()) {
            SwitchTable.SwitchSection section = iterator.next();
            if (!section.values.anyMatch(e -> e instanceof Nop)) continue;
            assert (!hasDefault) : "Switch must only have one default block.";
            hasDefault = true;
        }
        return (None)super.visitSwitchTable(switchTable, ctx);
    }

    @Override
    public None visitSwitchSection(SwitchTable.SwitchSection switchSection, None ctx) {
        assert (!switchSection.values.isEmpty());
        assert (switchSection.values.allMatch(e -> {
            FieldReference ref;
            return e instanceof LdcInsn || e instanceof Nop || e instanceof FieldReference && (ref = (FieldReference)e).getField().getAccessFlags().toSet().containsAll(LOAD_FLAG_MASK.toSet());
        }));
        return (None)super.visitSwitchSection(switchSection, ctx);
    }

    @Override
    public None visitTernary(Ternary ternary, None ctx) {
        assert (this.isAssignableTo(ternary.getCondition().getResultType(), PrimitiveType.BOOLEAN));
        return (None)super.visitTernary(ternary, ctx);
    }

    @Override
    public None visitTryCatch(TryCatch tryCatch, None ctx) {
        assert (!tryCatch.resources.isEmpty() || !tryCatch.handlers.isEmpty() || tryCatch.getFinallyBody() != null);
        return (None)super.visitTryCatch(tryCatch, ctx);
    }

    @Override
    public None visitYield(Yield yield, None ctx) {
        assert (yield.firstAncestorOfType(Switch.class) == yield.getSwitch());
        return (None)super.visitYield(yield, ctx);
    }

    public boolean isAssignableTo(AType from, AType to) {
        if (to == PrimitiveType.BOOLEAN) {
            return from == PrimitiveType.BOOLEAN || TypeSystem.isAssignableTo(from, BOOLEAN_CONSTANTS);
        }
        return TypeSystem.isAssignableTo(from, to);
    }

    public boolean isCastableTo(ReferenceType from, ReferenceType to) {
        return TypeSystem.isCastableTo(from, to, true);
    }
}

