/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class InstanceOf
extends Instruction {
    private AType type;
    private final InstructionSlot<Instruction> argument = new InstructionSlot(this);
    private final InstructionSlot<Instruction> pattern = new InstructionSlot(this);

    public InstanceOf(Instruction argument, AType type) {
        this.type = type;
        this.pattern.set(new Nop());
        this.argument.set(argument);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitInstanceOf(this, ctx);
    }

    @Override
    protected void onChildModified() {
        Instruction instruction;
        super.onChildModified();
        if (this.isConnected() && (instruction = this.getPattern()) instanceof Reference) {
            Reference ref = (Reference)instruction;
            ref.setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        Instruction instruction = this.getPattern();
        if (instruction instanceof Reference) {
            Reference ref = (Reference)instruction;
            ref.setWrittenTo(true);
        }
    }

    public AType getType() {
        return this.type;
    }

    public void setType(AType type) {
        this.type = type;
    }

    public Instruction getArgument() {
        return this.argument.get();
    }

    public void setArgument(Instruction argument) {
        this.argument.set(argument);
    }

    public Instruction getPattern() {
        return this.pattern.get();
    }

    public void setPattern(LocalReference pattern) {
        this.pattern.set(pattern);
    }
}

