package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;

/**
 * Created by covers1624 on 8/5/21.
 */
public interface ClassTransformer extends Transformer {

    /**
     * Transform a class. Called for all class types, but before
     * inner/local/anon classes have been added to their parent.
     * <p>
     * All methods have already been fully processed.
     * <p>
     * All inner/local/anon classes are present and already fully processed.
     *
     * @param cInsn The class.
     * @param ctx   The context.
     */
    void transform(ClassDecl cInsn, ClassTransformContext ctx);

}
