/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.git;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.javasauce.ss.tasks.git.AbstractGitTask;
import net.javasauce.ss.tasks.report.TestCaseDef;
import net.javasauce.ss.util.CommittedTestCaseDef;
import net.javasauce.ss.util.CommittedTestCasePair;
import net.javasauce.ss.util.ProcessableVersionSet;
import net.javasauce.ss.util.VersionManifest;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class ExtractTestStatsTask
extends AbstractGitTask {
    public final TaskInput<ProcessableVersionSet> versionSet = this.input("versionSet");
    public final TaskOutput<Map<String, CommittedTestCasePair>> testStats = this.computedOutput("testStats");

    private ExtractTestStatsTask(String name, Executor executor) {
        super(name, executor);
    }

    public static ExtractTestStatsTask create(String name, Executor executor, Consumer<ExtractTestStatsTask> cons) {
        ExtractTestStatsTask task = new ExtractTestStatsTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Git git = (Git)this.git.get();
        Repository repository = git.getRepository();
        ProcessableVersionSet versionSet = this.versionSet.get();
        HashMap<String, CommittedTestCasePair> defs = new HashMap<String, CommittedTestCasePair>();
        for (String id : versionSet.allVersions()) {
            VersionManifest manifest = versionSet.getManifest(id);
            String branchName = manifest.computeBranchName();
            Ref ref = repository.findRef(branchName);
            if (ref == null) continue;
            String nowCommit = ref.getObjectId().name();
            String beforeCommit = this.getParentCommit(nowCommit);
            defs.put(id, new CommittedTestCasePair(id, beforeCommit != null ? this.getTestDef(beforeCommit) : null, this.getTestDef(nowCommit)));
        }
        this.testStats.set(defs);
    }

    private CommittedTestCaseDef getTestDef(String commit) throws IOException {
        TestCaseDef testDef = (TestCaseDef)this.loadBlob(commit + ":src/main/resources/test_stats.json", TestCaseDef::loadTestStats);
        if (testDef == null) {
            throw new RuntimeException("Missing test defs for commit " + commit);
        }
        return new CommittedTestCaseDef(commit, this.getCommitMessage(commit), testDef);
    }
}

