/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.git;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitTask
extends Task {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public final TaskInput<Git> git = this.input("git");

    protected AbstractGitTask(String name, Executor executor) {
        super(name, executor);
    }

    protected void checkoutOrCreateBranch(String branch) throws GitAPIException, IOException {
        Git git = this.git.get();
        if (git.getRepository().findRef("refs/heads/" + branch) != null) {
            this.LOGGER.info("Checking out existing branch {}", (Object)branch);
            git.checkout().setName(branch).call();
            return;
        }
        if (git.getRepository().findRef("refs/remotes/origin/" + branch) != null) {
            this.LOGGER.info("Checking out existing remote branch {}", (Object)branch);
            git.checkout().setName(branch).setCreateBranch(true).setStartPoint("origin/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
            return;
        }
        this.LOGGER.info("Creating new branch {}", (Object)branch);
        git.checkout().setName(branch).setOrphan(true).call();
    }

    protected void stageChanges() throws GitAPIException {
        this.LOGGER.info("Staging changes.");
        this.git.get().add().addFilepattern(".").call();
        this.git.get().add().addFilepattern(".").setUpdate(true).call();
    }

    protected void commitChanges(String message) throws GitAPIException {
        this.LOGGER.info("Committing changes with message {}", (Object)message);
        this.git.get().commit().setAuthor("SnowShovel", "snowshovel@javasauce.net").setCommitter("SnowShovel", "snowshovel@javasauce.net").setAllowEmpty(true).setMessage(message).call();
    }

    protected void amendChanges(@Nullable String message) {
        this.LOGGER.info("Amending changes.");
        if (message == null) {
            message = this.getCommitMessage("HEAD");
        }
        try {
            this.git.get().commit().setAmend(true).setMessage(message).call();
        }
        catch (GitAPIException ex) {
            throw new RuntimeException("Failed to amend changes.", ex);
        }
    }

    protected void createTag(String tag) throws GitAPIException {
        this.LOGGER.info("Creating tag {}", (Object)tag);
        this.git.get().tag().setName(tag).setForceUpdate(true).call();
    }

    protected void pushAllBranches() throws GitAPIException {
        Iterable results = this.git.get().push().setRemote("origin").setPushAll().setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
        AbstractGitTask.validatePush(results);
    }

    protected void pushAllTags() throws GitAPIException {
        this.LOGGER.info("Pushing all tags...");
        Iterable results = this.git.get().push().setRemote("origin").setForce(true).setPushTags().setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
        AbstractGitTask.validatePush(results);
    }

    private static void validatePush(Iterable<PushResult> results) {
        ArrayList errors = FastStream.of(results).flatMap(PushResult::getRemoteUpdates).filter(e -> e.getStatus() != RemoteRefUpdate.Status.OK && e.getStatus() != RemoteRefUpdate.Status.UP_TO_DATE).map(e -> new RuntimeException("Failed to push %s to %s failed: %s %s".formatted(e.getSrcRef(), e.getRemoteName(), e.getStatus(), e.getMessage()))).toList();
        if (!errors.isEmpty()) {
            throw (RuntimeException)FastStream.of((Iterable)errors).fold((Object)new RuntimeException("Failed to push."), (a, b) -> {
                a.addSuppressed((Throwable)b);
                return a;
            });
        }
    }

    protected void wipeCheckedOutFiles() throws IOException {
        Git git = this.git.get();
        final Path gitDir = git.getRepository().getDirectory().toPath();
        final Path repoDir = gitDir.getParent();
        Files.walkFileTree(repoDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (dir.equals(gitDir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
                if (dir.equals(repoDir)) {
                    return FileVisitResult.TERMINATE;
                }
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Nullable
    protected <T> T loadBlob(String object, SneakyUtils.ThrowingFunction<ObjectStream, ? extends T, IOException> func) throws IOException {
        Git git = this.git.get();
        ObjectId blobId = git.getRepository().resolve(object);
        if (blobId == null) {
            return null;
        }
        ObjectLoader loader = git.getRepository().open((AnyObjectId)blobId);
        try (ObjectStream stream = loader.openStream();){
            Object object2 = func.apply((Object)stream);
            return (T)object2;
        }
    }

    protected Map<String, String> listAllTags() {
        try {
            Git git = this.git.get();
            RefDatabase refDb = git.getRepository().getRefDatabase();
            HashMap<String, String> entries = new HashMap<String, String>();
            for (Ref ref : git.tagList().call()) {
                Ref peeled = refDb.peel(ref);
                entries.put(Repository.shortenRefName((String)ref.getName()), peeled.getPeeledObjectId() != null ? peeled.getPeeledObjectId().getName() : peeled.getObjectId().getName());
            }
            return entries;
        }
        catch (IOException | GitAPIException ex) {
            throw new RuntimeException("Failed to list all branches.", ex);
        }
    }

    protected Map<String, String> listAllBranches() throws GitAPIException {
        return FastStream.of((Iterable)this.git.get().branchList().setListMode(ListBranchCommand.ListMode.ALL).call()).filter(e -> e.getObjectId() != null).toMap(e -> Repository.shortenRefName((String)e.getName()), e -> e.getObjectId().getName());
    }

    protected void fastForwardBranchToCommit(String branch, String commit) {
        Git git = this.git.get();
        try {
            Repository repo = git.getRepository();
            if (repo.getBranch().equals(branch) && repo.resolve("HEAD").getName().equals(commit)) {
                return;
            }
            if (repo.findRef("refs/heads/" + branch) != null) {
                this.LOGGER.info("Checking out existing branch {}", (Object)branch);
                git.checkout().setName(branch).call();
                this.fastForwardBranch(commit);
                return;
            }
            if (repo.findRef("refs/remotes/origin/" + branch) != null) {
                this.LOGGER.info("Checking out existing remote branch {}", (Object)branch);
                git.checkout().setName(branch).setCreateBranch(true).setStartPoint("origin/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
                this.fastForwardBranch(commit);
                return;
            }
            this.LOGGER.info("Creating new branch {}", (Object)branch);
            git.checkout().setCreateBranch(true).setName(branch).setStartPoint(commit).call();
        }
        catch (IOException | GitAPIException ex) {
            throw new RuntimeException("Failed to reset branch " + branch + " to commit " + commit, ex);
        }
    }

    protected void fastForwardBranch(String commit) throws IOException, GitAPIException {
        this.LOGGER.info("Fast-Forwarding to {}", (Object)commit);
        Git git = this.git.get();
        Repository repo = git.getRepository();
        MergeResult merge = git.merge().setFastForward(MergeCommand.FastForwardMode.FF_ONLY).include((AnyObjectId)repo.resolve(commit)).call();
        if (!merge.getMergeStatus().isSuccessful()) {
            throw new RuntimeException("Unable to fast forward branch. " + String.valueOf(merge.getMergeStatus()));
        }
    }

    protected String getCommitMessage(String ref) {
        String string;
        Repository repo = this.git.get().getRepository();
        RevWalk walk = new RevWalk(repo);
        try {
            string = walk.parseCommit((AnyObjectId)repo.resolve(ref)).getFullMessage();
        }
        catch (Throwable throwable) {
            try {
                try {
                    walk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to get commit message of ref.", ex);
            }
        }
        walk.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected String getParentCommit(String ref) {
        Repository repo = this.git.get().getRepository();
        try (RevWalk walk = new RevWalk(repo);){
            RevCommit commit = walk.parseCommit((AnyObjectId)repo.resolve(ref));
            if (commit.getParentCount() == 0) {
                String string = null;
                return string;
            }
            if (commit.getParentCount() > 1) {
                throw new RuntimeException("Commit " + ref + " has more than one parent commit. " + commit.getParentCount());
            }
            String string = commit.getParent(0).name();
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to get commit parent.", ex);
        }
    }
}

