/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.core.Pointer;
import net.covers1624.curl4j.curl_blob;
import net.covers1624.curl4j.util.CurlBindable;

public final class CABundle
implements CurlBindable {
    private static final CABundle BUILT_IN;
    private static CABundle DEFAULT;
    private final curl_blob blob = new curl_blob();

    public CABundle(byte[] data) {
        this.blob.setFlags(0);
        this.blob.setData(CABundle.toNativeBuffer(data));
        this.blob.setLen(Long.valueOf(data.length));
    }

    public static CABundle builtIn() {
        return BUILT_IN;
    }

    public static CABundle getDefault() {
        return DEFAULT;
    }

    public static void setDefault(CABundle bundle) {
        DEFAULT = bundle;
    }

    public static CABundle newBundleFromResource(String resource) throws IOException {
        try (InputStream is = CABundle.class.getResourceAsStream(resource);){
            if (is == null) {
                throw new FileNotFoundException("Embedded resource does not exist: " + resource);
            }
            CABundle cABundle = new CABundle(CABundle.toBytes(is));
            return cABundle;
        }
    }

    public static CABundle newBundleFromPath(Path path) throws IOException {
        return new CABundle(Files.readAllBytes(path));
    }

    @Override
    public void apply(long curl) {
        CURL.curl_easy_setopt(curl, 40309, this.getCABlob());
        CURL.curl_easy_setopt(curl, 40310, this.getCABlob());
    }

    public curl_blob getCABlob() {
        return this.blob;
    }

    private static Pointer toNativeBuffer(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return new Pointer(buffer);
    }

    private static byte[] toBytes(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            bos.write(buf, 0, len);
        }
        return bos.toByteArray();
    }

    static {
        try {
            BUILT_IN = CABundle.newBundleFromResource("/META-INF/ca-bundle.crt");
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to initialize default CABundle.", ex);
        }
        DEFAULT = BUILT_IN;
    }
}

