/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.nio.ByteBuffer;
import net.covers1624.curl4j.core.Memory;
import org.jetbrains.annotations.Nullable;

public class Pointer {
    @Nullable
    public final ByteBuffer buf;
    public final long address;

    public Pointer(long address) {
        this.buf = null;
        this.address = address;
    }

    public Pointer(ByteBuffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("Must be a direct buffer");
        }
        this.buf = buf;
        this.address = Memory.getDirectByteBufferAddress(buf);
    }

    public boolean readBoolean() {
        return Memory.getBoolean(this.address);
    }

    public byte readByte() {
        return Memory.getByte(this.address);
    }

    public short readShort() {
        return Memory.getShort(this.address);
    }

    public int readInt() {
        return Memory.getInt(this.address);
    }

    public long readLong() {
        return Memory.getLong(this.address);
    }

    public float readFloat() {
        return Memory.getFloat(this.address);
    }

    public double readDouble() {
        return Memory.getDouble(this.address);
    }

    public long readCLong() {
        return Memory.getCLong(this.address);
    }

    public long readSizeT() {
        return Memory.getSizeT(this.address);
    }

    public long readAddress() {
        return Memory.getAddress(this.address);
    }

    public Pointer readPointer() {
        return new Pointer(this.readAddress());
    }

    public String readUtf8Safe() {
        return Memory.readUtf8(this.address);
    }
}

