/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.httpapi;

import net.covers1624.curl4j.CABundle;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.httpapi.Curl4jEngineRequest;
import net.covers1624.curl4j.httpapi.HandlePool;
import net.covers1624.curl4j.util.CurlHandle;
import net.covers1624.curl4j.util.CurlMultiHandle;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.httpapi.HttpEngine;
import org.jetbrains.annotations.Nullable;

@Requires(value="net.covers1624:Quack", minVersion="0.4.111")
public class Curl4jHttpEngine
implements HttpEngine,
AutoCloseable {
    private static boolean CURL_GLOBAL_INIT = false;
    private final HandlePool<CurlHandle> CURL_HANDLES = new HandlePool<CurlHandle>(CurlHandle::create);
    private final HandlePool<CurlMultiHandle> MULTI_HANDLES = new HandlePool<CurlMultiHandle>(CurlMultiHandle::createMulti);
    @Nullable
    private final CABundle caBundle;
    @Nullable
    public final String impersonate;
    private boolean closed = false;

    public Curl4jHttpEngine() {
        this((CABundle)null);
    }

    public Curl4jHttpEngine(@Nullable CABundle caBundle) {
        this(caBundle, null);
    }

    public Curl4jHttpEngine(@Nullable String impersonate) {
        this(null, impersonate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Curl4jHttpEngine(@Nullable CABundle caBundle, @Nullable String impersonate) {
        this.caBundle = caBundle;
        this.impersonate = impersonate;
        if (!CURL.isCurlImpersonateSupported() && impersonate != null) {
            throw new IllegalArgumentException("Current CURL instance does not support impersonation.");
        }
        Class<Curl4jHttpEngine> clazz = Curl4jHttpEngine.class;
        synchronized (Curl4jHttpEngine.class) {
            if (!CURL_GLOBAL_INIT) {
                CURL.curl_global_init(3L);
                CURL_GLOBAL_INIT = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Curl4jEngineRequest newRequest() {
        if (this.closed) {
            throw new RuntimeException("Engine already closed.");
        }
        return new Curl4jEngineRequest(this).useCABundle(this.caBundle);
    }

    @Override
    public void close() {
        this.CURL_HANDLES.close();
        this.MULTI_HANDLES.close();
        this.closed = true;
    }

    @Nullable
    String getImpersonate() {
        return this.impersonate;
    }

    HandlePool.Entry getHandle() {
        return this.CURL_HANDLES.get();
    }

    HandlePool.Entry getMultiHandle() {
        return this.MULTI_HANDLES.get();
    }
}

