/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="RollingRandomAccessFile")
public final class RollingRandomAccessFileAppender
extends AbstractOutputStreamAppender<RollingRandomAccessFileManager> {
    private final String fileName;
    private final String filePattern;
    private final Object advertisement;
    private final Advertiser advertiser;

    private RollingRandomAccessFileAppender(String name, Layout layout, Filter filter, RollingRandomAccessFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, int bufferSize, Advertiser advertiser) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, null, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        } else {
            this.advertisement = null;
        }
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent event) {
        RollingRandomAccessFileManager manager = (RollingRandomAccessFileManager)this.getManager();
        manager.checkRollover(event);
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public int getBufferSize() {
        return ((RollingRandomAccessFileManager)this.getManager()).getBufferSize();
    }

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<RollingRandomAccessFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private @PluginBuilderAttribute(value="fileName") String fileName;
        @PluginBuilderAttribute(value="filePattern")
        private @PluginBuilderAttribute(value="filePattern") String filePattern;
        @PluginBuilderAttribute(value="append")
        private @PluginBuilderAttribute(value="append") boolean append = true;
        @PluginElement(value="Policy")
        private @PluginElement(value="Policy") TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private @PluginElement(value="Strategy") RolloverStrategy strategy;
        @PluginBuilderAttribute(value="advertise")
        private @PluginBuilderAttribute(value="advertise") boolean advertise;
        @PluginBuilderAttribute(value="advertiseURI")
        private @PluginBuilderAttribute(value="advertiseURI") String advertiseURI;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public Builder() {
            this.setBufferSize(262144);
            this.setIgnoreExceptions(true);
            this.setImmediateFlush(true);
        }

        public RollingRandomAccessFileAppender build() {
            int bufferSize;
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for FileAppender");
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().setCompressionLevelStr(String.valueOf(-1)).setConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().setCompressionLevelStr(String.valueOf(-1)).setConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a DirectFileRolloverStrategy must be configured", (Object)name);
                return null;
            }
            if (this.filePattern == null) {
                LOGGER.error("No filename pattern provided for FileAppender with name " + name);
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("A TriggeringPolicy must be provided");
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            boolean immediateFlush = this.isImmediateFlush();
            RollingRandomAccessFileManager manager = RollingRandomAccessFileManager.getRollingRandomAccessFileManager(this.fileName, this.filePattern, this.append, immediateFlush, bufferSize = this.getBufferSize(), this.policy, this.strategy, this.advertiseURI, layout, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
            if (manager == null) {
                return null;
            }
            manager.initialize();
            return new RollingRandomAccessFileAppender(name, layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), immediateFlush, bufferSize, this.advertise ? this.getConfiguration().getAdvertiser() : null);
        }

        public B setFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Builder)this.asBuilder());
        }

        public B setFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Builder)this.asBuilder());
        }

        public B setAppend(boolean append) {
            this.append = append;
            return (B)((Builder)this.asBuilder());
        }

        public B setPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Builder)this.asBuilder());
        }

        public B setStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Builder)this.asBuilder());
        }

        public B setAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Builder)this.asBuilder());
        }

        public B setAdvertiseURI(String advertiseURI) {
            this.advertiseURI = advertiseURI;
            return (B)((Builder)this.asBuilder());
        }

        public B setFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Builder)this.asBuilder());
        }

        public B setFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Builder)this.asBuilder());
        }

        public B setFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Builder)this.asBuilder());
        }
    }
}

