/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.file.FileWatcherCallback;
import net.rubygrapefruit.platform.internal.FunctionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFileEventFunctions
implements NativeIntegration {
    protected FileWatcher createWatcher(Collection<String> paths, FileWatcherCallback callback, WatcherFactory starter) {
        if (paths.isEmpty()) {
            return FileWatcher.EMPTY;
        }
        FunctionResult result = new FunctionResult();
        List<String> canonicalPaths = AbstractFileEventFunctions.canonicalizeAbsolutePaths(paths);
        FileWatcher watcher = starter.createWatcher(canonicalPaths.toArray(new String[0]), new NativeFileWatcherCallback(callback), result);
        if (result.isFailed()) {
            throw new NativeException("Failed to start watching. Reason: " + result.getMessage());
        }
        return watcher;
    }

    private static List<String> canonicalizeAbsolutePaths(Collection<String> watchRoots) {
        ArrayList<String> canonicalPaths = new ArrayList<String>(watchRoots.size());
        for (String watchRoot : watchRoots) {
            File fileRoot = new File(watchRoot);
            if (!fileRoot.isAbsolute()) {
                throw new NativeException("Watched root is not absolute: " + fileRoot);
            }
            try {
                canonicalPaths.add(fileRoot.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new NativeException("Couldn't resolve canonical path for: " + watchRoot, ex);
            }
        }
        return canonicalPaths;
    }

    protected static class NativeFileWatcherCallback {
        private final FileWatcherCallback delegate;

        public NativeFileWatcherCallback(FileWatcherCallback delegate) {
            this.delegate = delegate;
        }

        public void pathChanged(int type, String path) {
            this.delegate.pathChanged(FileWatcherCallback.Type.values()[type], path);
        }
    }

    protected static abstract class AbstractFileWatcher
    implements FileWatcher {
        private Object details;

        public AbstractFileWatcher(Object details) {
            this.details = details;
        }

        public void close() {
            if (this.details == null) {
                return;
            }
            FunctionResult result = new FunctionResult();
            this.stop(this.details, result);
            this.details = null;
            if (result.isFailed()) {
                throw new NativeException("Failed to stop watching. Reason: " + result.getMessage());
            }
        }

        protected abstract void stop(Object var1, FunctionResult var2);
    }

    protected static interface WatcherFactory {
        public FileWatcher createWatcher(String[] var1, NativeFileWatcherCallback var2, FunctionResult var3);
    }
}

