/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util.task;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.javasauce.ss.util.MemoizedSupplier;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskIO;
import org.jetbrains.annotations.Nullable;

public final class TaskOutput<T>
extends TaskIO<T> {
    private final boolean isComputed;
    @Nullable
    private MemoizedSupplier<CompletableFuture<T>> derivedFuture;
    @Nullable
    private CompletableFuture<T> future;
    @Nullable
    private T value;

    TaskOutput(Task task, String name, boolean isComputed) {
        super(task, name);
        this.isComputed = isComputed;
    }

    @Override
    public synchronized CompletableFuture<T> getFuture() {
        if (this.future == null) {
            this.future = this.getTask().getFuture().thenApply(e -> this.get());
        }
        return this.future;
    }

    @Override
    public T get() {
        return Objects.requireNonNull(this.value, "Output value has not been set yet.");
    }

    public void set(T value) {
        if (this.task.isFutureResolved() && !this.isComputed()) {
            throw new IllegalStateException("Unable to set Output value after task execution has been scheduled.");
        }
        this.value = value;
    }

    public <A> void deriveFrom(TaskIO<? extends A> aIo, Function<? super A, ? extends T> func) {
        if (this.isComputed()) {
            throw new UnsupportedOperationException("Currently can't use deriveFrom for computed outputs.");
        }
        if (this.task.isFutureResolved()) {
            throw new IllegalStateException("Unable to set Output value after task execution has been scheduled.");
        }
        this.derivedFuture = new MemoizedSupplier<CompletableFuture>(() -> aIo.getFuture().thenApply(e -> {
            this.value = func.apply((Object)e);
            return this.value;
        }));
    }

    public <A, B> void deriveFrom(TaskIO<? extends A> aIo, TaskIO<? extends B> bIo, BiFunction<? super A, ? super B, ? extends T> func) {
        if (this.isComputed()) {
            throw new UnsupportedOperationException("Currently can't use deriveFrom for computed outputs.");
        }
        if (this.task.isFutureResolved()) {
            throw new IllegalStateException("Unable to set Output value after task execution has been scheduled.");
        }
        this.derivedFuture = new MemoizedSupplier<CompletableFuture>(() -> aIo.getFuture().thenCombine((CompletionStage)bIo.getFuture(), (a, b) -> {
            this.value = func.apply((Object)a, (Object)b);
            return this.value;
        }));
    }

    @Override
    boolean isValueSet() {
        return this.value != null;
    }

    public boolean isComputed() {
        return this.isComputed;
    }

    @Nullable
    CompletableFuture<?> deriveFuture() {
        return this.derivedFuture != null ? this.derivedFuture.get() : null;
    }
}

