/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.covers1624.curl4j.CABundle;
import net.covers1624.curl4j.httpapi.Curl4jHttpEngine;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.javasauce.ss.tasks.DecompileTask;
import net.javasauce.ss.tasks.DownloadTask;
import net.javasauce.ss.tasks.PrepareToolTask;
import net.javasauce.ss.tasks.RemapperTask;
import net.javasauce.ss.tasks.detect.DetectChangesTask;
import net.javasauce.ss.tasks.git.CheckoutBranchTask;
import net.javasauce.ss.tasks.git.CommitTask;
import net.javasauce.ss.tasks.git.DeleteTagsTask;
import net.javasauce.ss.tasks.git.ExtractTestStatsTask;
import net.javasauce.ss.tasks.git.FastForwardTask;
import net.javasauce.ss.tasks.git.PushAllTask;
import net.javasauce.ss.tasks.git.SetupGitRepoTask;
import net.javasauce.ss.tasks.report.DiscordReportTask;
import net.javasauce.ss.tasks.report.GenerateComparisonsTask;
import net.javasauce.ss.tasks.util.BarrierTask;
import net.javasauce.ss.tasks.util.CopyTask;
import net.javasauce.ss.tasks.util.GenerateGradleProjectTask;
import net.javasauce.ss.tasks.util.GenerateRootProjectTask;
import net.javasauce.ss.tasks.util.SetupJdkTask;
import net.javasauce.ss.util.CommittedTestCasePair;
import net.javasauce.ss.util.DeleteHierarchyVisitor;
import net.javasauce.ss.util.DiscordWebhook;
import net.javasauce.ss.util.JdkProvider;
import net.javasauce.ss.util.LibraryDownload;
import net.javasauce.ss.util.ProcessableVersionSet;
import net.javasauce.ss.util.RunRequest;
import net.javasauce.ss.util.VersionManifest;
import net.javasauce.ss.util.VersionRequest;
import net.javasauce.ss.util.matrix.JobMatrix;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskIO;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowShovel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowShovel.class);
    @Nullable
    private static final String DISCORD_WEBHOOK = System.getenv("DISCORD_WEBHOOK");
    private static final ExecutorService DOWNLOAD_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Download executor %d").daemon(true).build());
    private static final ExecutorService REMAPPER_EXECUTOR = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Remapper Thread").daemon(true).build());
    private static final ExecutorService DECOMPILE_EXECUTOR = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Decompiler Thread").daemon(true).build());
    private static final ExecutorService GIT_EXECUTOR = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Git Thread").daemon(true).build());
    private static final Map<JavaVersion, SetupJdkTask> JDK_TASKS = new HashMap<JavaVersion, SetupJdkTask>();
    public static final MavenNotation FAST_REMAPPER_VERSION = MavenNotation.parse((String)"net.covers1624:FastRemapper:0.3.2.23@zip");
    public static final MavenNotation DECOMPILER_TEMPLATE = MavenNotation.parse((String)"net.javasauce:Decompiler:0:test-engine@zip");
    public static final String VERSION;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException {
        Git git;
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(List.of("h", "help"), "Prints this help").forHelp();
        OptionSpecBuilder runMatrixBuilder = parser.accepts("run-matrix", "Run using a matrix segment.");
        OptionSpecBuilder finalizeMatrixBuilder = parser.accepts("finalize-matrix", "Finalize a matrix run.");
        ArgumentAcceptingOptionSpec genMatrixOpt = parser.accepts("gen-matrix", "Generate a matrix for the current work.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec matrixSizeOpt = parser.accepts("matrix-size", "The number of versions to process in each job.").availableIf((OptionSpec)genMatrixOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)8, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec runMatrixOpt = runMatrixBuilder.availableUnless((OptionSpec)finalizeMatrixBuilder, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING}));
        ArgumentAcceptingOptionSpec finalizeMatrixOpt = finalizeMatrixBuilder.availableUnless((OptionSpec)runMatrixBuilder, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING}));
        ArgumentAcceptingOptionSpec gitRepoOpt = parser.accepts("gitRepo", "The remote git repository to use.").withRequiredArg();
        OptionSpecBuilder gitPushOpt = parser.accepts("gitPush", "If SnowShovel should push to the repository.");
        OptionSpecBuilder gitCleanOpt = parser.accepts("gitClean", "If SnowShovel should delete the previous checkout (if available) before doing stuff.");
        OptionSpecBuilder simulateFullRunOpt = parser.accepts("simulate-full-run", "Manually run a full decompile of all versions.");
        ArgumentAcceptingOptionSpec versionOpt = parser.accepts("only-version", "Dev only flag. Filter the versions to process, limited to any specified by this flag.").withRequiredArg().withValuesSeparatedBy(",");
        ArgumentAcceptingOptionSpec decompilerVersionOpt = parser.accepts("set-decompiler-version", "Dev only flag. Set the decompiler version to use.").availableIf((OptionSpec)simulateFullRunOpt, new OptionSpec[0]).withRequiredArg();
        OptionSet optSet = parser.parse(args);
        if (optSet.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
            return;
        }
        if (!optSet.has((OptionSpec)gitRepoOpt)) {
            LOGGER.error("The '--repo' argument is required.");
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
            return;
        }
        String repoUrl = (String)optSet.valueOf((OptionSpec)gitRepoOpt);
        String gitUser = System.getenv("GIT_USER");
        String gitPass = System.getenv("GIT_PASS");
        if (gitUser == null || gitPass == null) {
            LOGGER.error("GIT_USER and GIT_PASS environment variables are required.");
            System.exit(1);
            return;
        }
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider(gitUser, gitPass));
        Path workDir = Path.of(".", new String[0]).toAbsolutePath().normalize();
        Path versionsDir = workDir.resolve("versions");
        Path librariesDir = workDir.resolve("libraries");
        Path toolsDir = workDir.resolve("tools");
        Path tempDir = workDir.resolve("temp");
        Path repoDir = workDir.resolve("repo");
        Curl4jHttpEngine http = new Curl4jHttpEngine(CABundle.builtIn());
        JdkProvider jdkProvider = new JdkProvider(toolsDir.resolve("jdks/"), (HttpEngine)http);
        boolean shouldPush = optSet.has((OptionSpec)gitPushOpt);
        boolean shouldClean = optSet.has((OptionSpec)gitCleanOpt);
        boolean simulateFullRun = optSet.has((OptionSpec)simulateFullRunOpt);
        Optional<String> decompilerOverride = Optional.ofNullable((String)optSet.valueOf((OptionSpec)decompilerVersionOpt));
        List mcVersionOverride = optSet.valuesOf((OptionSpec)versionOpt);
        if (Files.exists(tempDir, new LinkOption[0])) {
            Files.walkFileTree(tempDir, new DeleteHierarchyVisitor());
        }
        SetupGitRepoTask gitSetupTask = SetupGitRepoTask.create("setupGit", GIT_EXECUTOR, task -> {
            task.repoDir.set(repoDir);
            task.repoUrl.set(repoUrl);
            task.clearClone.set(shouldClean);
        });
        CheckoutBranchTask checkoutMain = CheckoutBranchTask.create("checkoutMain", GIT_EXECUTOR, task -> {
            task.git.set(gitSetupTask.output);
            task.branch.set("main");
        });
        Task.runTasks(checkoutMain);
        try (Git git2 = git = gitSetupTask.output.get();
             ExecutorService executorService = DOWNLOAD_EXECUTOR;
             ExecutorService executorService2 = REMAPPER_EXECUTOR;
             ExecutorService executorService3 = DECOMPILE_EXECUTOR;
             ExecutorService executorService4 = GIT_EXECUTOR;){
            Stage1Pair stage1;
            if (optSet.has((OptionSpec)genMatrixOpt)) {
                stage1 = SnowShovel.runStage1((HttpEngine)http, repoDir, gitSetupTask, simulateFullRun, mcVersionOverride, decompilerOverride, shouldPush);
                if (stage1 == null) {
                    LOGGER.info("No changes.");
                    return;
                }
                if (shouldPush) {
                    PushAllTask pushTask = PushAllTask.create("pushAllTags", GIT_EXECUTOR, task -> {
                        task.git.set(gitSetupTask.output);
                        task.tags.set(true);
                    });
                    Task.runTasks(pushTask);
                }
                JobMatrix matrix = RunRequest.splitJobs(stage1.runRequest, (Integer)optSet.valueOf((OptionSpec)matrixSizeOpt));
                JobMatrix.write((Path)optSet.valueOf((OptionSpec)genMatrixOpt), matrix);
                return;
            }
            if (optSet.has((OptionSpec)runMatrixOpt)) {
                FastForwardTask fastForwardMain = FastForwardTask.create("fastForwardMain", GIT_EXECUTOR, task -> {
                    task.git.set(gitSetupTask.output);
                    task.branch.set("main");
                    task.tag.set(Optional.of("temp/main"));
                });
                Task.runTasks(fastForwardMain);
                ProcessableVersionSet versionSet = new ProcessableVersionSet((HttpEngine)http, repoDir.resolve("cache"));
                versionSet.allVersions();
                RunRequest runRequest = RunRequest.parse((Path)optSet.valueOf((OptionSpec)runMatrixOpt));
                SnowShovel.runStage2((HttpEngine)http, jdkProvider, toolsDir, librariesDir, versionsDir, tempDir, repoDir, runRequest, versionSet, gitSetupTask, shouldPush, repoUrl);
                return;
            }
            if (optSet.has((OptionSpec)finalizeMatrixOpt)) {
                FastForwardTask fastForwardMain = FastForwardTask.create("fastForwardMain", GIT_EXECUTOR, task -> {
                    task.git.set(gitSetupTask.output);
                    task.branch.set("main");
                    task.tag.set(Optional.of("temp/main"));
                });
                Task.runTasks(fastForwardMain);
                ProcessableVersionSet versionSet = new ProcessableVersionSet((HttpEngine)http, repoDir.resolve("cache"));
                JobMatrix matrix = JobMatrix.parse((Path)optSet.valueOf((OptionSpec)finalizeMatrixOpt));
                RunRequest runRequest = RunRequest.mergeJobs(matrix);
                SnowShovel.runStage3((HttpEngine)http, repoDir, runRequest, versionSet, gitSetupTask, shouldPush, repoUrl);
                return;
            }
            stage1 = SnowShovel.runStage1((HttpEngine)http, repoDir, gitSetupTask, simulateFullRun, mcVersionOverride, decompilerOverride, shouldPush);
            if (stage1 == null) {
                LOGGER.info("No changes.");
                return;
            }
            SnowShovel.runStage2((HttpEngine)http, jdkProvider, toolsDir, librariesDir, versionsDir, tempDir, repoDir, stage1.runRequest, stage1.versionSet, gitSetupTask, shouldPush, repoUrl);
            SnowShovel.runStage3((HttpEngine)http, repoDir, stage1.runRequest, stage1.versionSet, gitSetupTask, shouldPush, repoUrl);
        }
        LOGGER.info("Done!");
    }

    @Nullable
    private static Stage1Pair runStage1(HttpEngine http, Path repoDir, SetupGitRepoTask gitSetupTask, boolean simulateFullRun, List<String> mcVersionOverride, Optional<String> decompilerOverride, boolean shouldPush) throws IOException {
        DetectChangesTask detectChanges = DetectChangesTask.create("detectChanges", ForkJoinPool.commonPool(), task -> {
            task.http.set(http);
            task.cacheDir.set(repoDir.resolve("cache"));
            task.versionFilters.set(mcVersionOverride);
            task.decompilerOverride.set(decompilerOverride);
            task.simulateFullRun.set(simulateFullRun);
        });
        Task.runTasks(detectChanges);
        RunRequest runRequest = detectChanges.runRequest.get().orElse(null);
        if (runRequest == null) {
            return null;
        }
        ProcessableVersionSet versionSet = detectChanges.versionSet.get();
        CommitTask tempTagMain = CommitTask.create("tagMain", GIT_EXECUTOR, task -> {
            task.git.set(gitSetupTask.output);
            task.commitMessage.set(Optional.of(runRequest.reason()));
            task.tagName.set(Optional.of("temp/main"));
        });
        BarrierTask pushMainTagBarrier = new BarrierTask("pushMainTag");
        pushMainTagBarrier.dependsOn(tempTagMain);
        if (shouldPush) {
            PushAllTask pushTask = PushAllTask.create("pushMainTag", GIT_EXECUTOR, task -> {
                task.dependsOn(tempTagMain);
                task.git.set(gitSetupTask.output);
                task.tags.set(true);
            });
            pushMainTagBarrier.dependsOn(pushTask);
        }
        Task.runTasks(pushMainTagBarrier);
        if (DISCORD_WEBHOOK != null) {
            new DiscordWebhook(DISCORD_WEBHOOK).setContent("SnowShovel run starting, processing " + runRequest.versions().size() + " versions.").execute(http);
        }
        return new Stage1Pair(runRequest, versionSet);
    }

    private static void runStage2(HttpEngine http, JdkProvider jdkProvider, Path toolsDir, Path librariesDir, Path versionsDir, Path tempDir, Path repoDir, RunRequest runRequest, ProcessableVersionSet versionSet, SetupGitRepoTask gitSetupTask, boolean shouldPush, String repoUrl) {
        PrepareToolTask prepareRemapper = PrepareToolTask.create("prepareRemapper", DOWNLOAD_EXECUTOR, http, task -> {
            task.notation.set(FAST_REMAPPER_VERSION);
            task.toolDir.set(toolsDir);
        });
        PrepareToolTask prepareDecompiler = PrepareToolTask.create("prepareDecompiler", DOWNLOAD_EXECUTOR, http, task -> {
            task.notation.set(DECOMPILER_TEMPLATE.withVersion(runRequest.decompilerVersion()));
            task.toolDir.set(toolsDir);
        });
        DownloadTask downloadGradleWrapper = DownloadTask.create("downloadGradleWrapper", DOWNLOAD_EXECUTOR, http, task -> {
            task.output.set(librariesDir.resolve("GradleWrapper.zip"));
            task.url.set("https://covers1624.net/Files/GradleWrapper-8.10.2.zip");
            task.downloadLen.set(44825L);
            task.downloadHash.set(Optional.of("2e355d2ede2307bfe40330db29f52b9b729fd9b2"));
        });
        HashMap libraryDownloads = new HashMap();
        BarrierTask gitTagAllBarrier = new BarrierTask("gitTagAllBarrier");
        for (VersionRequest version : runRequest.versions()) {
            String id = version.id();
            VersionManifest manifest = versionSet.getManifest(id);
            DownloadTask downloadClient = DownloadTask.create("downloadClient_" + id, DOWNLOAD_EXECUTOR, http, task -> {
                VersionManifest.Download download = manifest.downloads().get("client");
                task.output.set(versionsDir.resolve(id).resolve(id + "-client.jar"));
                task.url.set(download.url());
                task.downloadHash.set(Optional.of(download.sha1()));
                task.downloadLen.set(download.size());
            });
            DownloadTask downloadClientMappings = DownloadTask.create("downloadClientMappings_" + id, DOWNLOAD_EXECUTOR, http, task -> {
                VersionManifest.Download download = manifest.downloads().get("client_mappings");
                task.output.set(versionsDir.resolve(id).resolve(id + "-client_mappings.jar"));
                task.url.set(download.url());
                task.downloadHash.set(Optional.of(download.sha1()));
                task.downloadLen.set(download.size());
            });
            RemapperTask remapClient = RemapperTask.create("remapClient_" + id, REMAPPER_EXECUTOR, task -> {
                task.tool.set((TaskIO<PrepareToolTask.PreparedTool>)prepareRemapper.output);
                task.javaHome.set((TaskIO<Path>)SnowShovel.getJdkTask((JdkProvider)jdkProvider, (JavaVersion)JavaVersion.JAVA_17).javaHome);
                task.input.set((TaskIO<Path>)downloadClient.output);
                task.mappings.set((TaskIO<Path>)downloadClientMappings.output);
                task.remapped.set(versionsDir.resolve(id).resolve(id + "-client-remapped.jar"));
            });
            List<LibraryDownload> libDefs = LibraryDownload.getVersionLibraries(manifest, librariesDir);
            ArrayList libraries = FastStream.of(libDefs).map(library -> libraryDownloads.computeIfAbsent(library, e2 -> DownloadTask.create("downloadLibrary_" + String.valueOf(library.notation()), DOWNLOAD_EXECUTOR, http, task -> {
                task.url.set(library.url());
                task.output.set(library.path());
                task.downloadHash.set(Optional.ofNullable(library.sha1()));
                task.downloadLen.set(library.size());
            }))).toList();
            DecompileTask decompileTask = DecompileTask.create("decompile_" + id, DECOMPILE_EXECUTOR, task -> {
                task.javaRuntimeHome.set((TaskIO<Path>)SnowShovel.getJdkTask((JdkProvider)jdkProvider, (JavaVersion)SnowShovel.pickDecompilerJavaVersion((JavaVersion)JavaVersion.JAVA_21, (JavaVersion)manifest.computeJavaVersion())).javaHome);
                task.javaReferenceHome.set((TaskIO<Path>)SnowShovel.getJdkTask((JdkProvider)jdkProvider, (JavaVersion)manifest.computeJavaVersion()).javaHome);
                task.tool.set((TaskIO<PrepareToolTask.PreparedTool>)prepareDecompiler.output);
                task.libraries.set(FastStream.of((Iterable)libraries).map(e -> e.output).toList());
                task.inputJar.set((TaskIO<Path>)remapClient.remapped);
                task.output.set(tempDir.resolve(id));
            });
            String branchName = manifest.computeBranchName();
            CheckoutBranchTask checkoutBranchTask = CheckoutBranchTask.create("checkout_" + id, GIT_EXECUTOR, task -> {
                task.dependsOn(decompileTask);
                task.git.set(gitSetupTask.output);
                task.branch.set(branchName);
                task.clean.set(true);
            });
            CopyTask copyTask = CopyTask.create("copyDecompileResults_" + id, GIT_EXECUTOR, task -> {
                task.dependsOn(checkoutBranchTask);
                task.input.set((TaskIO<Path>)decompileTask.output);
                task.output.set(repoDir);
            });
            GenerateGradleProjectTask genProjectTask = GenerateGradleProjectTask.create("generateGradleProject_" + id, GIT_EXECUTOR, task -> {
                task.dependsOn(checkoutBranchTask);
                task.projectDir.set(repoDir);
                task.gradleWrapperDist.set((TaskIO<Path>)downloadGradleWrapper.output);
                task.javaVersion.set(manifest.computeJavaVersion());
                task.libraries.set(libDefs);
                task.mcManifest.set(manifest);
                task.gitRepoUrl.set(repoUrl);
            });
            CommitTask commitTask = CommitTask.create("commitAndTag_" + id, GIT_EXECUTOR, task -> {
                task.dependsOn(copyTask);
                task.dependsOn(genProjectTask);
                task.git.set(gitSetupTask.output);
                task.commitMessage.set(Optional.of(version.commitName()));
                task.tagName.set(Optional.of("temp/" + branchName));
            });
            gitTagAllBarrier.dependsOn(commitTask);
        }
        BarrierTask pushAllTagsBarrier = new BarrierTask("pushAllTags");
        pushAllTagsBarrier.dependsOn(gitTagAllBarrier);
        if (shouldPush) {
            PushAllTask pushTask = PushAllTask.create("pushAllTags", GIT_EXECUTOR, task -> {
                task.dependsOn(gitTagAllBarrier);
                task.git.set(gitSetupTask.output);
                task.tags.set(true);
            });
            pushAllTagsBarrier.dependsOn(pushTask);
        }
        Task.runTasks(pushAllTagsBarrier);
    }

    private static void runStage3(HttpEngine http, Path repoDir, RunRequest runRequest, ProcessableVersionSet versionSet, SetupGitRepoTask gitSetupTask, boolean shouldPush, String repoUrl) throws IOException {
        BarrierTask fastForwardBarrier = new BarrierTask("fastForwardBarrier");
        ArrayList<Object> tagsToDelete = new ArrayList<Object>();
        for (VersionRequest version : runRequest.versions()) {
            VersionManifest manifest = versionSet.getManifest(version.id());
            String branch = manifest.computeBranchName();
            String tag = "temp/" + branch;
            FastForwardTask fastForward = FastForwardTask.create("fastForward_" + version.id(), GIT_EXECUTOR, task -> {
                task.git.set(gitSetupTask.output);
                task.branch.set(branch);
                task.tag.set(Optional.of(tag));
            });
            tagsToDelete.add(tag);
            fastForwardBarrier.dependsOn(fastForward);
        }
        FastForwardTask fastForwardMain = FastForwardTask.create("fastForwardMain", GIT_EXECUTOR, task -> {
            task.dependsOn(fastForwardBarrier);
            task.git.set(gitSetupTask.output);
            task.branch.set("main");
            task.tag.set(Optional.of("temp/main"));
        });
        tagsToDelete.add("temp/main");
        ExtractTestStatsTask extractStats = ExtractTestStatsTask.create("extractTestStats", GIT_EXECUTOR, task -> {
            task.dependsOn(fastForwardMain);
            task.git.set(gitSetupTask.output);
            task.versionSet.set(versionSet);
        });
        GenerateRootProjectTask genRootProject = GenerateRootProjectTask.create("genRootProject", ForkJoinPool.commonPool(), task -> {
            task.dependsOn(fastForwardMain);
            task.projectDir.set(repoDir);
            task.versions.set(versionSet);
            task.testDefs.set((TaskIO<Map<String, CommittedTestCasePair>>)extractStats.testStats);
            task.gitRepoUrl.set(repoUrl);
        });
        CommitTask amendMain = CommitTask.create("amendMain", GIT_EXECUTOR, task -> {
            task.dependsOn(genRootProject);
            task.git.set(gitSetupTask.output);
            task.amend.set(true);
        });
        BarrierTask pushBarrier = new BarrierTask("pushBarrier");
        pushBarrier.dependsOn(amendMain);
        if (shouldPush) {
            PushAllTask pushTask = PushAllTask.create("pushAllBranches", GIT_EXECUTOR, task -> {
                task.git.set(gitSetupTask.output);
                task.dependsOn(amendMain);
                task.branches.set(true);
            });
            pushBarrier.dependsOn(pushTask);
        }
        DeleteTagsTask deleteTags = DeleteTagsTask.create("deleteTags", GIT_EXECUTOR, task -> {
            task.dependsOn(pushBarrier);
            task.git.set(gitSetupTask.output);
            task.tagNames.set(tagsToDelete);
            task.local.set(true);
            task.remote.set(shouldPush);
        });
        BarrierTask discordPostBarrier = new BarrierTask("discordPostBarrier");
        if (DISCORD_WEBHOOK != null) {
            GenerateComparisonsTask genComparisons = GenerateComparisonsTask.create("genComparisons", ForkJoinPool.commonPool(), task -> {
                task.dependsOn(pushBarrier);
                task.stats.set((TaskIO<Map<String, CommittedTestCasePair>>)extractStats.testStats);
            });
            DiscordReportTask discordReport = DiscordReportTask.create("discordReport", ForkJoinPool.commonPool(), task -> {
                task.webhook.set(DISCORD_WEBHOOK);
                task.gitRepoUrl.set(repoUrl);
                task.http.set(http);
                task.versions.set(versionSet.allVersions());
                task.postDefs.set((TaskIO<Map<String, CommittedTestCasePair>>)extractStats.testStats);
                task.comparisons.set((TaskIO<Map<String, GenerateComparisonsTask.CaseComparison>>)genComparisons.comparisons);
            });
            discordPostBarrier.dependsOn(discordReport);
        }
        Task.runTasks(pushBarrier, deleteTags, discordPostBarrier);
        if (DISCORD_WEBHOOK != null) {
            new DiscordWebhook(DISCORD_WEBHOOK).setContent("SnowShovel run finished, processed " + runRequest.versions().size() + " versions.").execute(http);
        }
    }

    private static SetupJdkTask getJdkTask(JdkProvider jdkProvider, JavaVersion javaVersion) {
        return JDK_TASKS.computeIfAbsent(javaVersion, e -> SetupJdkTask.create("provisionJdk_" + javaVersion.shortString, DOWNLOAD_EXECUTOR, jdkProvider, task -> task.javaVersion.set(javaVersion)));
    }

    private static JavaVersion pickDecompilerJavaVersion(JavaVersion a, JavaVersion b) {
        if (a.ordinal() > b.ordinal()) {
            return a;
        }
        return b;
    }

    static {
        String version = null;
        Package pkg = SnowShovel.class.getPackage();
        if (pkg != null) {
            version = pkg.getImplementationVersion();
        }
        VERSION = version != null ? version : "dev";
    }

    private record Stage1Pair(RunRequest runRequest, ProcessableVersionSet versionSet) {
    }
}

