/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.git;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.javasauce.ss.tasks.git.AbstractGitTask;
import net.javasauce.ss.util.task.TaskInput;

public class FastForwardTask
extends AbstractGitTask {
    public final TaskInput<String> branch = this.input("branch");
    public final TaskInput<Optional<String>> tag = this.optionalInput("tag");
    public final TaskInput<Optional<String>> commit = this.optionalInput("commit");

    private FastForwardTask(String name, Executor executor) {
        super(name, executor);
    }

    public static FastForwardTask create(String name, Executor executor, Consumer<FastForwardTask> cons) {
        FastForwardTask task = new FastForwardTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        String commit;
        String tag = this.tag.get().orElse(null);
        if (tag == null == ((commit = (String)this.commit.get().orElse(null)) == null)) {
            throw new RuntimeException("One of tag or commit must be set.");
        }
        if (tag != null && (commit = this.listAllTags().get(tag)) == null) {
            throw new RuntimeException("Tag " + tag + " does not exist.");
        }
        this.fastForwardBranchToCommit(this.branch.get(), commit);
    }
}

