/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.CurlWriteCallback;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.util.CurlBindable;
import org.jetbrains.annotations.Nullable;

public class CurlOutput
implements Closeable,
CurlBindable {
    private final OutputSupplier<WritableByteChannel> channelSupplier;
    @Nullable
    private CurlWriteCallback callback;
    @Nullable
    private WritableByteChannel channel;
    private boolean closed;

    protected CurlOutput(OutputSupplier<WritableByteChannel> channelSupplier) {
        this.channelSupplier = channelSupplier;
    }

    public static CurlOutput toChannel(OutputSupplier<WritableByteChannel> supplier) {
        return new CurlOutput(supplier);
    }

    public static CurlOutput toStream(OutputSupplier<OutputStream> supplier) {
        return CurlOutput.toChannel(() -> Channels.newChannel((OutputStream)supplier.open()));
    }

    public static CurlOutput toFile(Path path) {
        return CurlOutput.toChannel(() -> {
            Path parent = path.getParent();
            if (parent != null && !Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        });
    }

    public static CurlOutput toFile(File file) {
        return CurlOutput.toFile(file.toPath());
    }

    public CurlWriteCallback callback() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        if (this.callback == null) {
            this.callback = new CurlWriteCallback((ptr, size, nmemb, userdata) -> {
                if (this.channel == null) {
                    this.channel = this.channelSupplier.open();
                }
                int rs = (int)(size * nmemb);
                ByteBuffer buffer = Memory.newDirectByteBuffer(ptr, rs);
                return this.channel.write(buffer);
            });
        }
        return this.callback;
    }

    @Override
    public void apply(long curl) {
        CURL.curl_easy_setopt(curl, 20011, this.callback());
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.callback != null) {
            this.callback.close();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.closed = true;
    }

    @FunctionalInterface
    public static interface OutputSupplier<T> {
        public T open() throws IOException;
    }
}

