/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.CurlHeaderCallback;
import net.covers1624.curl4j.util.CurlBindable;
import org.jetbrains.annotations.Nullable;

public class HeaderCollector
implements AutoCloseable,
CurlBindable {
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    @Nullable
    private CurlHeaderCallback callback;
    private boolean closed;

    public CurlHeaderCallback callback() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        if (this.callback == null) {
            this.callback = new CurlHeaderCallback((header, userdata) -> {
                int colon = header.indexOf(":");
                if (colon == -1) {
                    if (header.startsWith("HTTP/")) {
                        this.headers.clear();
                    }
                    return;
                }
                String[] split = header.trim().split(":", 2);
                this.headers.computeIfAbsent(split[0], e -> new ArrayList(1)).add(split[1].trim());
            });
        }
        return this.callback;
    }

    @Override
    public void apply(long curl) {
        CURL.curl_easy_setopt(curl, 20079, this.callback());
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public void close() {
        if (this.callback != null) {
            this.callback.close();
        }
        this.closed = true;
    }
}

