/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.jdkutils.JavaInstall;
import net.javasauce.ss.tasks.PrepareToolTask;
import net.javasauce.ss.util.ProcessUtils;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemapperTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemapperTask.class);
    public final TaskInput<PrepareToolTask.PreparedTool> tool = this.input("tool");
    public final TaskInput<Path> javaHome = this.input("javaHome");
    public final TaskInput<Path> input = this.input("input");
    public final TaskInput<Path> mappings = this.input("mappings");
    public final TaskOutput<Path> remapped = this.output("remapped");

    private RemapperTask(String name, Executor executor) {
        super(name, executor);
        this.withCaching(this.remapped, cache -> {
            cache.add(this.tool, PrepareToolTask.PreparedTool::toolJar);
            cache.add(this.input);
            cache.add(this.mappings);
            cache.add(this.remapped);
        });
    }

    public static RemapperTask create(String name, Executor executor, Consumer<RemapperTask> configure) {
        RemapperTask task = new RemapperTask(name, executor);
        configure.accept(task);
        return task;
    }

    @Override
    protected void execute() {
        PrepareToolTask.PreparedTool tool = this.tool.get();
        Path input = this.input.get();
        Path mappings = this.mappings.get();
        Path remapped = this.remapped.get();
        LOGGER.info("Remapping {} with {}", this.input, (Object)tool.toolJar());
        ProcessUtils.ProcessResult procResult = ProcessUtils.runProcess(JavaInstall.getJavaExecutable((Path)this.javaHome.get(), (boolean)true), List.of("-jar", tool.toolJar().toAbsolutePath().toString(), "--input", input.toAbsolutePath().toString(), "--mappings", mappings.toAbsolutePath().toString(), "--output", remapped.toAbsolutePath().toString(), "--flip", "--all-fixers"), tool.workingDir(), arg_0 -> ((Logger)LOGGER).info(arg_0));
        procResult.assertExitCode(0);
    }
}

