/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.covers1624.quack.collection.FastStream;
import net.javasauce.ss.util.MemoizedSupplier;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskIO;
import net.javasauce.ss.util.task.TaskOutput;
import org.jetbrains.annotations.Nullable;

public sealed class TaskInput<T>
extends TaskIO<T> {
    @Nullable
    private Supplier<CompletableFuture<T>> futureSupplier;

    TaskInput(Task task, String name) {
        super(task, name);
    }

    @Override
    public synchronized CompletableFuture<T> getFuture() {
        if (this.futureSupplier == null) {
            throw new IllegalStateException("IO " + this.getName() + " of task " + this.task.getName() + " has not had a value assigned.");
        }
        return this.futureSupplier.get();
    }

    @Override
    public T get() {
        return this.getFuture().join();
    }

    public void set(T value) {
        this.set(() -> CompletableFuture.completedFuture(value));
    }

    public void set(TaskIO<T> io) {
        this.set(io::getFuture);
    }

    public <A> void deriveFrom(TaskIO<A> aIo, Function<? super A, ? extends T> func) {
        this.set(() -> aIo.getFuture().thenApply(func));
    }

    public <A, B> void deriveFrom(TaskIO<A> aIo, TaskIO<B> bIo, BiFunction<? super A, ? super B, ? extends T> func) {
        this.set(() -> aIo.getFuture().thenCombineAsync((CompletionStage)bIo.getFuture(), func));
    }

    protected final void set(Supplier<CompletableFuture<T>> futureSupplier) {
        if (this.task.isFutureResolved()) {
            throw new IllegalStateException("Unable to set Input value after task execution has been scheduled.");
        }
        this.futureSupplier = new MemoizedSupplier<CompletableFuture<CompletableFuture<T>>>(futureSupplier);
    }

    @Override
    boolean isValueSet() {
        return this.futureSupplier != null;
    }

    public static final class Collection<E>
    extends TaskInput<List<E>> {
        Collection(Task task, String name) {
            super(task, name);
        }

        @Override
        public void set(List<TaskOutput<E>> outputs) {
            ((TaskInput)this).set(() -> {
                ArrayList futures = FastStream.of((Iterable)outputs).map(TaskIO::getFuture).toList();
                return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(e -> FastStream.of((Iterable)futures).map(CompletableFuture::join).toList());
            });
        }
    }
}

