/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@Requires(value="org.ow2.asm:asm")
public class JavaPropExtractGenerator {
    public static String[] DEFAULTS = new String[]{"java.home", "java.version", "java.vendor", "os.arch", "java.vm.name", "java.vm.version", "java.runtime.name", "java.runtime.version", "java.class.version"};
    private static final byte[] DEFAULT_CLASS_BYTES = (byte[])SneakyUtils.sneaky(() -> {
        InputStream is = JavaPropExtractGenerator.class.getResourceAsStream("/assets/PropExtract.class.bin");
        if (is == null) {
            throw new ExceptionInInitializerError("Unable to locate 'PropExtract.class' asset.");
        }
        try (InputStream _is = is;){
            byte[] byArray = IOUtils.toBytes((InputStream)_is);
            return byArray;
        }
    });

    public static Path writeClass(Path folder) throws IOException {
        Path classFile = folder.resolve("PropExtract.class");
        Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(classFile, new OpenOption[0]);){
            os.write(DEFAULT_CLASS_BYTES);
            os.flush();
        }
        return classFile;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new IllegalArgumentException("Expected single argument.");
        }
        Path path = Paths.get(args[0], new String[0]).toAbsolutePath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            os.write(JavaPropExtractGenerator.generateClass());
            os.flush();
        }
    }

    public static byte[] generateClass() {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(196653, 33, "PropExtract", null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
        mv.visitCode();
        int array = 0;
        int out = 1;
        int index = 2;
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        mv.visitVarInsn(58, out);
        Label head = new Label();
        Label after = new Label();
        mv.visitInsn(3);
        mv.visitVarInsn(54, index);
        mv.visitLabel(head);
        mv.visitVarInsn(21, index);
        mv.visitVarInsn(25, array);
        mv.visitInsn(190);
        mv.visitJumpInsn(162, after);
        mv.visitVarInsn(25, out);
        mv.visitVarInsn(25, array);
        mv.visitVarInsn(21, index);
        mv.visitInsn(50);
        mv.visitMethodInsn(182, "java/io/PrintStream", "print", "(Ljava/lang/String;)V", false);
        mv.visitVarInsn(25, out);
        mv.visitLdcInsn((Object)"=");
        mv.visitMethodInsn(182, "java/io/PrintStream", "print", "(Ljava/lang/String;)V", false);
        mv.visitVarInsn(25, out);
        mv.visitVarInsn(25, array);
        mv.visitVarInsn(21, index);
        mv.visitInsn(50);
        mv.visitLdcInsn((Object)"");
        mv.visitMethodInsn(184, "java/lang/System", "getProperty", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
        mv.visitIincInsn(index, 1);
        mv.visitJumpInsn(167, head);
        mv.visitLabel(after);
        mv.visitInsn(177);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
        return cw.toByteArray();
    }
}

