/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(printObject=true)
@Plugin
public class DirectWriteRolloverStrategy
extends AbstractRolloverStrategy
implements DirectFileRolloverStrategy {
    private static final int DEFAULT_MAX_FILES = 7;
    private final int maxFiles;
    private final int compressionLevel;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;
    private volatile String currentFileName;
    private int nextIndex = -1;
    private final PatternProcessor tempCompressedFilePattern;

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    protected DirectWriteRolloverStrategy(int maxFiles, int compressionLevel, StrSubstitutor strSubstitutor, Action[] customActions, boolean stopCustomActionsOnError, String tempCompressedFilePatternString, Configuration configuration) {
        super(strSubstitutor);
        this.maxFiles = maxFiles;
        this.compressionLevel = compressionLevel;
        this.stopCustomActionsOnError = stopCustomActionsOnError;
        this.customActions = customActions == null ? Collections.emptyList() : Arrays.asList(customActions);
        this.tempCompressedFilePattern = tempCompressedFilePatternString != null ? new PatternProcessor(configuration, tempCompressedFilePatternString) : null;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public PatternProcessor getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    private int purge(RollingFileManager manager) {
        SortedMap<Integer, Path> eligibleFiles = this.getEligibleFiles(manager);
        LOGGER.debug("Found {} eligible files, max is  {}", (Object)eligibleFiles.size(), (Object)this.maxFiles);
        while (eligibleFiles.size() >= this.maxFiles) {
            try {
                Integer key = eligibleFiles.firstKey();
                Files.delete((Path)eligibleFiles.get(key));
                eligibleFiles.remove(key);
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to delete {}", (Object)eligibleFiles.firstKey(), (Object)ioe);
                break;
            }
        }
        return eligibleFiles.size() > 0 ? eligibleFiles.lastKey() : 1;
    }

    @Override
    public String getCurrentFileName(RollingFileManager manager) {
        if (this.currentFileName == null) {
            String name;
            SortedMap<Integer, Path> eligibleFiles = this.getEligibleFiles(manager);
            int fileIndex = eligibleFiles.size() > 0 ? (this.nextIndex > 0 ? this.nextIndex : eligibleFiles.lastKey()) : 1;
            StringBuilder buf = new StringBuilder(255);
            manager.getPatternProcessor().setCurrentFileTime(System.currentTimeMillis());
            manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, true, (Object)fileIndex);
            int suffixLength = this.suffixLength(buf.toString());
            this.currentFileName = name = suffixLength > 0 ? buf.substring(0, buf.length() - suffixLength) : buf.toString();
        }
        return this.currentFileName;
    }

    @Override
    public void clearCurrentFileName() {
        this.currentFileName = null;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The name of the accessed files is based on a configuration value.")
    public RolloverDescription rollover(RollingFileManager manager) throws SecurityException {
        LOGGER.debug("Rolling " + this.currentFileName);
        if (this.maxFiles < 0) {
            return null;
        }
        long startNanos = System.nanoTime();
        int fileIndex = this.purge(manager);
        if (LOGGER.isTraceEnabled()) {
            double durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            LOGGER.trace("DirectWriteRolloverStrategy.purge() took {} milliseconds", (Object)durationMillis);
        }
        Action compressAction = null;
        String sourceName = this.getCurrentFileName(manager);
        Object compressedName = sourceName;
        this.currentFileName = null;
        this.nextIndex = fileIndex + 1;
        FileExtension fileExtension = manager.getFileExtension();
        if (fileExtension != null) {
            compressedName = (String)compressedName + fileExtension.getExtension();
            if (this.tempCompressedFilePattern != null) {
                StringBuilder buf = new StringBuilder();
                this.tempCompressedFilePattern.formatFileName(this.strSubstitutor, buf, (Object)fileIndex);
                String tmpCompressedName = buf.toString();
                File tmpCompressedNameFile = new File(tmpCompressedName);
                File parentFile = tmpCompressedNameFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                compressAction = new CompositeAction(Arrays.asList(fileExtension.createCompressAction(sourceName, tmpCompressedName, true, this.compressionLevel), new FileRenameAction(tmpCompressedNameFile, new File((String)compressedName), true)), true);
            } else {
                compressAction = fileExtension.createCompressAction(sourceName, (String)compressedName, true, this.compressionLevel);
            }
        }
        if (compressAction != null && manager.isAttributeViewEnabled()) {
            PosixViewAttributeAction posixAttributeViewAction = PosixViewAttributeAction.newBuilder().setBasePath((String)compressedName).setFollowLinks(false).setMaxDepth(1).setPathConditions(PathCondition.EMPTY_ARRAY).setSubst(this.getStrSubstitutor()).setFilePermissions(manager.getFilePermissions()).setFileOwner(manager.getFileOwner()).setFileGroup(manager.getFileGroup()).build();
            compressAction = new CompositeAction(Arrays.asList(compressAction, posixAttributeViewAction), false);
        }
        Action asyncAction = this.merge(compressAction, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl(sourceName, false, null, asyncAction);
    }

    public String toString() {
        return "DirectWriteRolloverStrategy(maxFiles=" + this.maxFiles + ")";
    }

    public static class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<DirectWriteRolloverStrategy> {
        @PluginBuilderAttribute(value="maxFiles")
        private @PluginBuilderAttribute(value="maxFiles") String maxFiles;
        @PluginBuilderAttribute(value="compressionLevel")
        private @PluginBuilderAttribute(value="compressionLevel") String compressionLevelStr;
        @PluginElement(value="Actions")
        private @PluginElement(value="Actions") Action[] customActions;
        @PluginBuilderAttribute(value="stopCustomActionsOnError")
        private @PluginBuilderAttribute(value="stopCustomActionsOnError") boolean stopCustomActionsOnError = true;
        @PluginBuilderAttribute(value="tempCompressedFilePattern")
        private @PluginBuilderAttribute(value="tempCompressedFilePattern") String tempCompressedFilePattern;
        @PluginConfiguration
        private Configuration config;

        public DirectWriteRolloverStrategy build() {
            int maxIndex = Integer.MAX_VALUE;
            if (this.maxFiles != null) {
                maxIndex = Integer.parseInt(this.maxFiles);
                if (maxIndex < 0) {
                    maxIndex = Integer.MAX_VALUE;
                } else if (maxIndex < 2) {
                    AbstractRolloverStrategy.LOGGER.error("Maximum files too small. Limited to 7");
                    maxIndex = 7;
                }
            }
            int compressionLevel = Integers.parseInt(this.compressionLevelStr, -1);
            return new DirectWriteRolloverStrategy(maxIndex, compressionLevel, this.config.getStrSubstitutor(), this.customActions, this.stopCustomActionsOnError, this.tempCompressedFilePattern, this.config);
        }

        public String getMaxFiles() {
            return this.maxFiles;
        }

        public Builder setMaxFiles(String maxFiles) {
            this.maxFiles = maxFiles;
            return this;
        }

        public String getCompressionLevelStr() {
            return this.compressionLevelStr;
        }

        public Builder setCompressionLevelStr(String compressionLevelStr) {
            this.compressionLevelStr = compressionLevelStr;
            return this;
        }

        public Action[] getCustomActions() {
            return this.customActions;
        }

        public Builder setCustomActions(Action ... customActions) {
            this.customActions = customActions;
            return this;
        }

        public boolean isStopCustomActionsOnError() {
            return this.stopCustomActionsOnError;
        }

        public Builder setStopCustomActionsOnError(boolean stopCustomActionsOnError) {
            this.stopCustomActionsOnError = stopCustomActionsOnError;
            return this;
        }

        public String getTempCompressedFilePattern() {
            return this.tempCompressedFilePattern;
        }

        public Builder setTempCompressedFilePattern(String tempCompressedFilePattern) {
            this.tempCompressedFilePattern = tempCompressedFilePattern;
            return this;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Builder setConfig(Configuration config) {
            this.config = config;
            return this;
        }
    }
}

