/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.net.httpapi.WebBody;
import org.jetbrains.annotations.Nullable;

public class DiscordWebhook {
    private final String url;
    @Nullable
    private String content;
    @Nullable
    private String username;
    @Nullable
    private String avatarUrl;
    private boolean tts;
    private final List<Embed> embeds = new ArrayList<Embed>();

    public DiscordWebhook(String url) {
        this.url = url;
    }

    public DiscordWebhook setContent(String content) {
        this.content = content;
        return this;
    }

    public DiscordWebhook setUsername(String username) {
        this.username = username;
        return this;
    }

    public DiscordWebhook setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    public DiscordWebhook setTts(boolean tts) {
        this.tts = tts;
        return this;
    }

    public DiscordWebhook addEmbed(Embed embed) {
        this.embeds.add(embed);
        return this;
    }

    public DiscordWebhook addEmbeds(Collection<Embed> embeds) {
        this.embeds.addAll(embeds);
        return this;
    }

    public void execute(HttpEngine http) throws IOException {
        if (this.content == null && this.embeds.isEmpty()) {
            throw new IllegalArgumentException("Set content or add at least one EmbedObject");
        }
        JsonObject json = new JsonObject();
        json.addProperty("content", this.content);
        json.addProperty("username", this.username);
        json.addProperty("avatar_url", this.avatarUrl);
        json.addProperty("tts", Boolean.valueOf(this.tts));
        if (!this.embeds.isEmpty()) {
            JsonArray embedObjects = new JsonArray();
            for (Embed embed : this.embeds) {
                JsonObject jsonEmbed = new JsonObject();
                jsonEmbed.addProperty("title", embed.getTitle());
                jsonEmbed.addProperty("description", embed.getDescription());
                jsonEmbed.addProperty("url", embed.getUrl());
                if (embed.getColor() != null) {
                    Color color = embed.getColor();
                    int rgb = color.getRed();
                    rgb = (rgb << 8) + color.getGreen();
                    rgb = (rgb << 8) + color.getBlue();
                    jsonEmbed.addProperty("color", (Number)rgb);
                }
                Embed.Footer footer = embed.getFooter();
                Embed.Image image = embed.getImage();
                Embed.Thumbnail thumbnail = embed.getThumbnail();
                Embed.Author author = embed.getAuthor();
                List<Embed.Field> fields = embed.getFields();
                if (footer != null) {
                    JsonObject jsonFooter = new JsonObject();
                    jsonFooter.addProperty("text", footer.text());
                    jsonFooter.addProperty("icon_url", footer.iconUrl());
                    jsonEmbed.add("footer", (JsonElement)jsonFooter);
                }
                if (image != null) {
                    JsonObject jsonImage = new JsonObject();
                    jsonImage.addProperty("url", image.url());
                    jsonEmbed.add("image", (JsonElement)jsonImage);
                }
                if (thumbnail != null) {
                    JsonObject jsonThumbnail = new JsonObject();
                    jsonThumbnail.addProperty("url", thumbnail.url());
                    jsonEmbed.add("thumbnail", (JsonElement)jsonThumbnail);
                }
                if (author != null) {
                    JsonObject jsonAuthor = new JsonObject();
                    jsonAuthor.addProperty("name", author.name());
                    jsonAuthor.addProperty("url", author.url());
                    jsonAuthor.addProperty("icon_url", author.iconUrl());
                    jsonEmbed.add("author", (JsonElement)jsonAuthor);
                }
                JsonArray jsonFields = new JsonArray();
                for (Embed.Field field : fields) {
                    JsonObject jsonField = new JsonObject();
                    jsonField.addProperty("name", field.name());
                    jsonField.addProperty("value", field.value());
                    jsonField.addProperty("inline", Boolean.valueOf(field.inline()));
                    jsonFields.add((JsonElement)jsonField);
                }
                jsonEmbed.add("fields", (JsonElement)jsonFields);
                embedObjects.add((JsonElement)jsonEmbed);
            }
            json.add("embeds", (JsonElement)embedObjects);
        }
        EngineRequest request = http.newRequest().method("POST", WebBody.string((String)json.toString(), (String)"application/json")).url(this.url);
        try (EngineResponse response = request.execute();){
            if (response.statusCode() != 200 && response.statusCode() != 204) {
                WebBody responseBody = response.body();
                String body = responseBody != null ? responseBody.asString() : null;
                throw new RuntimeException("Got: " + response.statusCode() + "\n" + String.join((CharSequence)"\n", response.headers().toStrings()) + "\n\n" + body);
            }
        }
    }

    public static class Embed {
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String url;
        @Nullable
        private Color color;
        @Nullable
        private Footer footer;
        @Nullable
        private Thumbnail thumbnail;
        @Nullable
        private Image image;
        @Nullable
        private Author author;
        private final List<Field> fields = new ArrayList<Field>();

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        @Nullable
        public Footer getFooter() {
            return this.footer;
        }

        @Nullable
        public Thumbnail getThumbnail() {
            return this.thumbnail;
        }

        @Nullable
        public Image getImage() {
            return this.image;
        }

        @Nullable
        public Author getAuthor() {
            return this.author;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public Embed setTitle(String title) {
            this.title = title;
            return this;
        }

        public Embed setDescription(String description) {
            this.description = description;
            return this;
        }

        public Embed setUrl(String url) {
            this.url = url;
            return this;
        }

        public Embed setColor(Color color) {
            this.color = color;
            return this;
        }

        public Embed setFooter(String text, String icon) {
            this.footer = new Footer(text, icon);
            return this;
        }

        public Embed setThumbnail(String url) {
            this.thumbnail = new Thumbnail(url);
            return this;
        }

        public Embed setImage(String url) {
            this.image = new Image(url);
            return this;
        }

        public Embed setAuthor(String name, String url, String icon) {
            this.author = new Author(name, url, icon);
            return this;
        }

        public Embed addField(String name, String value, boolean inline) {
            this.fields.add(new Field(name, value, inline));
            return this;
        }

        public boolean hasFields() {
            return !this.fields.isEmpty();
        }

        public record Footer(String text, String iconUrl) {
        }

        public record Thumbnail(String url) {
        }

        public record Image(String url) {
        }

        public record Author(String name, String url, String iconUrl) {
        }

        public record Field(String name, String value, boolean inline) {
        }
    }
}

