/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.git;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.quack.collection.FastStream;
import net.javasauce.ss.tasks.git.AbstractGitTask;
import net.javasauce.ss.util.task.TaskInput;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.RefSpec;

public class DeleteTagsTask
extends AbstractGitTask {
    public final TaskInput<List<String>> tagNames = this.input("tagNames");
    public final TaskInput<Boolean> local = this.input("remote", false);
    public final TaskInput<Boolean> remote = this.input("remote", false);

    private DeleteTagsTask(String name, Executor executor) {
        super(name, executor);
    }

    public static DeleteTagsTask create(String name, Executor executor, Consumer<DeleteTagsTask> cons) {
        DeleteTagsTask task = new DeleteTagsTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Git git = (Git)this.git.get();
        List<String> tagNames = this.tagNames.get();
        Boolean local = this.local.get();
        Boolean remote = this.remote.get();
        if (!local.booleanValue() && !remote.booleanValue()) {
            throw new IllegalArgumentException("Expected one or both of local/remote.");
        }
        if (local.booleanValue()) {
            git.tagDelete().setTags((String[])tagNames.toArray(String[]::new)).call();
        }
        if (remote.booleanValue()) {
            git.push().setRemote("origin").setForce(true).setRefSpecs((List)FastStream.of(tagNames).map(e -> new RefSpec(":refs/tags/" + e)).toList()).call();
        }
    }
}

