/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.lang.Nullable;
import org.apache.logging.log4j.plugins.PluginException;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.NotInjectableException;
import org.apache.logging.log4j.plugins.di.spi.DependencyChain;
import org.apache.logging.log4j.plugins.di.spi.FactoryResolver;
import org.apache.logging.log4j.plugins.di.spi.ResolvableKey;
import org.apache.logging.log4j.status.StatusLogger;

public class OptionalFactoryResolver<T>
implements FactoryResolver<Optional<T>> {
    @Override
    public boolean supportsKey(Key<?> key) {
        Type type = key.getType();
        return type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Optional.class;
    }

    @Override
    public Supplier<Optional<T>> getFactory(ResolvableKey<Optional<T>> resolvableKey, InstanceFactory instanceFactory) {
        Key<Optional<T>> key = resolvableKey.key();
        Key<@Nullable P> itemKey = key.getParameterizedTypeArgument(0);
        Collection<String> aliases = resolvableKey.aliases();
        DependencyChain dependencyChain = resolvableKey.dependencyChain();
        if (itemKey == null) {
            throw new NotInjectableException(resolvableKey);
        }
        return () -> {
            try {
                return Optional.ofNullable(instanceFactory.getInstance(itemKey, aliases, dependencyChain));
            }
            catch (PluginException e) {
                StatusLogger.getLogger().trace("Error while getting instance for {} with dependencies {}", (Object)itemKey, (Object)dependencyChain, (Object)e);
                return Optional.empty();
            }
        };
    }
}

