/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks;

import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.quack.collection.FastStream;
import net.javasauce.ss.tasks.PrepareToolTask;
import net.javasauce.ss.util.ProcessUtils;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompileTask
extends Task {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(DecompileTask.class);
    public final TaskInput<Path> javaRuntimeHome = this.input("javaRuntimeHome");
    public final TaskInput<Path> javaReferenceHome = this.input("javaReferenceHome");
    public final TaskInput<PrepareToolTask.PreparedTool> tool = this.input("tool");
    public final TaskInput.Collection<Path> libraries = this.inputCollection("libraries");
    public final TaskInput<Path> inputJar = this.input("inputJar");
    public final TaskInput<List<String>> javacArgs = this.input("javacArgs");
    public final TaskOutput<Path> output = this.output("output");

    private DecompileTask(String name, Executor executor) {
        super(name, executor);
    }

    public static DecompileTask create(String name, Executor executor, Consumer<DecompileTask> cons) {
        DecompileTask task = new DecompileTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Path output = this.output.get();
        ArrayList<Path> libraryPath = new ArrayList<Path>();
        libraryPath.add(this.inputJar.get());
        libraryPath.addAll((Collection)this.libraries.get());
        List<String> javacArgs = this.javacArgs.get();
        PrepareToolTask.PreparedTool tool = this.tool.get();
        ProcessUtils.ProcessResult procResult = ProcessUtils.runProcess(JavaInstall.getJavaExecutable((Path)this.javaRuntimeHome.get(), (boolean)true), List.of("-ea", "-XX:-OmitStackTraceInFastThrow", "-Dcoffeegrinder.testcases.library=true", "-Dcoffeegrinder.testcases.library.update_defs=true", "-Dcoffeegrinder.test.update=true", "-Dcoffeegrinder.test.java_under_test=" + String.valueOf(JavaInstall.getJavaExecutable((Path)this.javaReferenceHome.get(), (boolean)true)), "-Dcoffeegrinder.test.output=" + String.valueOf(output.resolve("src/main/java").toAbsolutePath()), "-Dcoffeegrinder.test.compile_error_output=" + String.valueOf(output.resolve("src/main/java").toAbsolutePath()), "-Dcoffeegrinder.test.rt_diff_output=" + String.valueOf(output.resolve("src/main/java").toAbsolutePath()), "-Dcoffeegrinder.test.stats=" + String.valueOf(output.resolve("src/main/resources/test_stats.json").toAbsolutePath()), "-Dcoffeegrinder.test.classes=" + String.valueOf(this.inputJar.get().toAbsolutePath()), "-Dcoffeegrinder.test.libraries=" + FastStream.of(libraryPath).map(Path::toAbsolutePath).map(Path::toString).join(File.pathSeparator), "-Dcoffeegrinder.test.javac_args=" + GSON.toJson(javacArgs), "-jar", tool.toolJar().toAbsolutePath().toString(), "execute", "--scan-classpath", "--include-engine", "testcase-library-engine", "--details=summary"), tool.workingDir(), arg_0 -> ((Logger)LOGGER).info(arg_0));
    }
}

