/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.util.SneakyUtils;
import net.javasauce.ss.util.Hashing;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final HttpEngine http;
    public final TaskOutput<Path> output = this.output("output");
    public final TaskInput<String> url = this.input("url");
    public final TaskInput<Optional<Path>> localOverride = this.optionalInput("localOverride");
    public final TaskInput<Optional<String>> downloadHash = this.optionalInput("downloadHash");
    public final TaskInput<Long> downloadLen = this.input("downloadLen", -1L);
    private final List<SneakyUtils.ThrowingConsumer<Path, IOException>> mutators = new ArrayList<SneakyUtils.ThrowingConsumer<Path, IOException>>();

    private DownloadTask(String name, Executor executor, HttpEngine http) {
        super(name, executor);
        this.http = http;
        this.withCaching(this.output, "_dl", cache -> {
            cache.add(this.output);
            cache.add(this.url);
            cache.add(this.downloadHash);
            cache.add(this.downloadLen);
            cache.add(this.localOverride);
        });
    }

    public static DownloadTask create(String name, Executor executor, HttpEngine http, Consumer<DownloadTask> configure) {
        DownloadTask task = new DownloadTask(name, executor, http);
        configure.accept(task);
        return task;
    }

    public DownloadTask addMutator(SneakyUtils.ThrowingConsumer<Path, IOException> mutFunc) {
        this.mutators.add(mutFunc);
        return this;
    }

    @Override
    protected void execute() throws IOException {
        Path output = this.output.get();
        String url = this.url.get();
        String downloadHash = this.downloadHash.get().orElse(null);
        long downloadLen = this.downloadLen.get();
        Path override = this.localOverride.get().orElse(null);
        if (override != null) {
            Files.copy(override, IOUtils.makeParents((Path)output), StandardCopyOption.REPLACE_EXISTING);
            if (DownloadTask.validate(output, downloadLen, downloadHash)) {
                LOGGER.info("Using local override for download of {}", (Object)output);
                return;
            }
        }
        LOGGER.info("Downloading file {} to {}", (Object)output, (Object)url);
        DownloadTask.doDownload(this.http, url, output, downloadLen, downloadHash);
        for (SneakyUtils.ThrowingConsumer<Path, IOException> mutator : this.mutators) {
            mutator.accept((Object)output);
        }
    }

    private static void doDownload(HttpEngine http, String url, Path output, long downloadLen, @Nullable String downloadHash) throws IOException {
        IOException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                new HttpEngineDownloadAction(http).setUrl(url).setDest(output).setQuiet(false).execute();
                if (!DownloadTask.validate(output, downloadLen, downloadHash)) {
                    LOGGER.error("Download validations failed. File will be re-downloaded.");
                    continue;
                }
                exception = null;
                break;
            }
            catch (IOException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static boolean validate(Path file, long length, @Nullable String sha1) throws IOException {
        if (length != -1L && Files.size(file) != length) {
            return false;
        }
        if (sha1 != null) {
            return Hashing.hashFile("SHA-1", file).equals(sha1);
        }
        return true;
    }
}

