/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.javasauce.ss.tasks.DownloadTask;
import net.javasauce.ss.tasks.util.UnzipTask;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskIO;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.jetbrains.annotations.Nullable;

public class PrepareToolTask
extends Task {
    public final TaskInput<MavenNotation> notation = this.input("notation");
    public final TaskInput<Path> toolDir = this.input("toolDir");
    public final TaskOutput<PreparedTool> output = this.computedOutput("output");
    private final TaskInput<Path> extractedDir = this.input("extractedDir");

    private PrepareToolTask(String name, Executor executor, HttpEngine http) {
        super(name, executor);
        DownloadTask downloadToolTask = DownloadTask.create(name + "_download", executor, http, (DownloadTask task) -> {
            task.output.deriveFrom(this.toolDir, this.notation, (t, n) -> n.toPath(t));
            task.url.deriveFrom(this.notation, e -> e.toURL("https://maven.covers1624.net").toString());
            task.localOverride.deriveFrom(this.notation, e -> Optional.ofNullable(PrepareToolTask.findMavenLocalFile(e)));
        });
        this.declareCompositeTask(downloadToolTask);
        UnzipTask extractTask = UnzipTask.create(name + "_unzip", executor, task -> {
            task.zip.set((TaskIO<Path>)downloadToolTask.output);
            task.output.deriveFrom(this.toolDir, this.notation, (t, n) -> t.resolve(n.toModulePath()).resolve(Objects.requireNonNull(n.version)).resolve(n.module + "-" + n.version));
        });
        this.declareCompositeTask(extractTask);
        this.extractedDir.set((TaskIO<Path>)extractTask.output);
    }

    public static PrepareToolTask create(String name, Executor executor, HttpEngine http, Consumer<PrepareToolTask> configure) {
        PrepareToolTask task = new PrepareToolTask(name, executor, http);
        configure.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        MavenNotation notation = this.notation.get();
        Path extractedDir = this.extractedDir.get();
        Path toolJar = extractedDir.resolve(notation.withExtension("jar").toFileName());
        this.output.set(new PreparedTool(toolJar, extractedDir));
    }

    @Nullable
    private static Path findMavenLocalFile(MavenNotation notation) {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            return null;
        }
        Path mavenLocalFile = notation.toPath(Path.of(userHome, new String[0]).resolve(".m2/repository"));
        if (!Files.exists(mavenLocalFile, new LinkOption[0])) {
            return null;
        }
        return mavenLocalFile;
    }

    public record PreparedTool(Path toolJar, Path workingDir) {
    }
}

