/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.git;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.javasauce.ss.tasks.git.AbstractGitTask;
import net.javasauce.ss.util.task.TaskInput;

public class CommitTask
extends AbstractGitTask {
    public final TaskInput<Boolean> amend = this.input("amend", false);
    public final TaskInput<Optional<String>> commitMessage = this.optionalInput("commitMessage");
    public final TaskInput<Optional<String>> tagName = this.optionalInput("tagName");

    private CommitTask(String name, Executor executor) {
        super(name, executor);
    }

    public static CommitTask create(String name, Executor executor, Consumer<CommitTask> cons) {
        CommitTask task = new CommitTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        this.stageChanges();
        if (this.amend.get().booleanValue()) {
            this.amendChanges(this.commitMessage.get().orElse(null));
        } else {
            this.commitChanges(this.commitMessage.get().orElseThrow(() -> new RuntimeException("Expected commitMessage to exist for non-amends.")));
        }
        String tag = this.tagName.get().orElse(null);
        if (tag != null) {
            this.createTag(tag);
        }
    }
}

