/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.javasauce.ss.util.DeleteHierarchyVisitor;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupGitRepoTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetupGitRepoTask.class);
    public final TaskInput<Path> repoDir = this.input("repoDir");
    public final TaskInput<String> repoUrl = this.input("repoUrl");
    public final TaskInput<Boolean> clearClone = this.input("clearClone", false);
    public final TaskOutput<Git> output = this.computedOutput("output");

    private SetupGitRepoTask(String name, Executor executor) {
        super(name, executor);
    }

    public static SetupGitRepoTask create(String name, Executor executor, Consumer<SetupGitRepoTask> cons) {
        SetupGitRepoTask task = new SetupGitRepoTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Path repoDir = this.repoDir.get();
        String repoUrl = this.repoUrl.get();
        if (this.clearClone.get().booleanValue() && Files.exists(repoDir, new LinkOption[0])) {
            Files.walkFileTree(repoDir, new DeleteHierarchyVisitor());
        }
        LOGGER.info("Setting up checkout of {} in {}", (Object)repoUrl, (Object)repoDir);
        try {
            Git git = Files.exists(repoDir, new LinkOption[0]) ? Git.open((File)repoDir.toFile()) : Git.cloneRepository().setDirectory(repoDir.toFile()).setURI(repoUrl).setNoCheckout(true).setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
            this.output.set(git);
        }
        catch (IOException | GitAPIException ex) {
            throw new RuntimeException("Failed to init git repo.", ex);
        }
    }
}

