/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.quack.collection.FastStream;
import net.javasauce.ss.tasks.report.TestCaseDef;
import net.javasauce.ss.tasks.report.TestCaseState;
import net.javasauce.ss.util.CommittedTestCaseDef;
import net.javasauce.ss.util.CommittedTestCasePair;
import net.javasauce.ss.util.RunRequest;
import net.javasauce.ss.util.VersionRequest;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.jetbrains.annotations.Nullable;

public class GenerateComparisonsTask
extends Task {
    public final TaskInput<Map<String, CommittedTestCasePair>> stats = this.input("stats");
    public final TaskInput<RunRequest> runRequest = this.input("runRequest");
    public final TaskOutput<Map<String, CaseComparison>> comparisons = this.computedOutput("comparisons");

    public GenerateComparisonsTask(String name, Executor executor) {
        super(name, executor);
    }

    public static GenerateComparisonsTask create(String name, Executor executor, Consumer<GenerateComparisonsTask> cons) {
        GenerateComparisonsTask task = new GenerateComparisonsTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Map<String, CommittedTestCasePair> stats = this.stats.get();
        RunRequest runRequest = this.runRequest.get();
        ArrayList ranVersions = FastStream.of(runRequest.versions()).map(VersionRequest::id).toList();
        FastStream added = FastStream.of((Iterable)ranVersions).filterNot(stats.keySet()::contains);
        FastStream common = FastStream.of((Iterable)ranVersions).filter(stats.keySet()::contains);
        FastStream removed = FastStream.of((Iterable)ranVersions).filterNot(stats.keySet()::contains);
        HashMap comparisons = new HashMap();
        added.forEach(id -> comparisons.put(id, GenerateComparisonsTask.compareCases(null, ((CommittedTestCasePair)stats.get(id)).now())));
        removed.forEach(id -> comparisons.put(id, GenerateComparisonsTask.compareCases(((CommittedTestCasePair)stats.get(id)).before(), null)));
        common.forEach(id -> comparisons.put(id, GenerateComparisonsTask.compareCases(((CommittedTestCasePair)stats.get(id)).before(), ((CommittedTestCasePair)stats.get(id)).now())));
        this.comparisons.set(comparisons);
    }

    public static CaseComparison compareCases(@Nullable CommittedTestCaseDef left, @Nullable CommittedTestCaseDef right) {
        if (left == null && right == null) {
            throw new IllegalArgumentException("Left and Right can't be null.");
        }
        if (left == null) {
            return CaseComparison.added(GenerateComparisonsTask.sumCases(right.def()), right.commit());
        }
        if (right == null) {
            return CaseComparison.removed(GenerateComparisonsTask.sumCases(left.def()), left.commit());
        }
        HashMap a = FastStream.of(left.def().cases.entrySet()).toMap(Map.Entry::getKey, e -> ((TestCaseDef.Case)e.getValue()).target);
        HashMap b = FastStream.of(right.def().cases.entrySet()).toMap(Map.Entry::getKey, e -> ((TestCaseDef.Case)e.getValue()).target);
        int[] numCases = new int[4];
        for (TestCaseState value : b.values()) {
            int n = value.ordinal();
            numCases[n] = numCases[n] + 1;
        }
        int[] addedTotal = new int[4];
        int[] removedTotal = new int[4];
        int[] improvedStats = new int[4];
        int[] regressedStats = new int[4];
        FastStream.of(a.keySet()).filter(b.keySet()::contains).forEach(name -> {
            TestCaseState bState;
            TestCaseState aState = (TestCaseState)((Object)((Object)a.get(name)));
            if (aState != (bState = (TestCaseState)((Object)((Object)b.get(name))))) {
                int n = aState.ordinal();
                removedTotal[n] = removedTotal[n] + 1;
                int n2 = bState.ordinal();
                addedTotal[n2] = addedTotal[n2] + 1;
                if (bState.ordinal() > aState.ordinal()) {
                    int n3 = bState.ordinal();
                    improvedStats[n3] = improvedStats[n3] + 1;
                } else {
                    int n4 = bState.ordinal();
                    regressedStats[n4] = regressedStats[n4] + 1;
                }
            }
        });
        return new CaseComparison(ComparisonType.COMPARE, left.commit(), right.commit(), numCases, addedTotal, removedTotal, improvedStats, regressedStats);
    }

    private static int[] sumCases(TestCaseDef def) {
        int[] numCases = new int[4];
        for (Map.Entry<String, TestCaseDef.Case> c : def.cases.entrySet()) {
            int n = c.getValue().target.ordinal();
            numCases[n] = numCases[n] + 1;
        }
        return numCases;
    }

    public record CaseComparison(ComparisonType type, @Nullable String leftCommit, @Nullable String rightCommit, int[] numCases, int[] addedTotal, int[] removedTotal, int[] improvedStats, int[] regressedStats) {
        public static CaseComparison added(int[] sum, String commit) {
            return new CaseComparison(ComparisonType.ADDED, null, commit, sum, sum, new int[0], new int[0], new int[0]);
        }

        public static CaseComparison removed(int[] sum, String commit) {
            return new CaseComparison(ComparisonType.REMOVED, commit, null, sum, new int[0], sum, new int[0], new int[0]);
        }
    }

    public static enum ComparisonType {
        COMPARE,
        ADDED,
        REMOVED;

    }
}

