/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.io.IndentPrintWriter;
import net.javasauce.ss.tasks.report.TestCaseDef;
import net.javasauce.ss.tasks.util.UnzipTask;
import net.javasauce.ss.util.LibraryDownload;
import net.javasauce.ss.util.ReportTableGenerator;
import net.javasauce.ss.util.VersionManifest;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskIO;
import net.javasauce.ss.util.task.TaskInput;
import org.jetbrains.annotations.Nullable;

public class GenerateGradleProjectTask
extends Task {
    public final TaskInput<Path> projectDir = this.input("projectDir");
    public final TaskInput<Path> gradleWrapperDist = this.input("gradleWrapperDist");
    public final TaskInput<JavaVersion> javaVersion = this.input("javaVersion");
    public final TaskInput<List<LibraryDownload>> libraries = this.input("libraries");
    public final TaskInput<VersionManifest> mcManifest = this.input("mcManifest");
    public final TaskInput<String> gitRepoUrl = this.input("gitRepoUrl");

    private GenerateGradleProjectTask(String name, Executor executor) {
        super(name, executor);
        UnzipTask zipTask = UnzipTask.create(name + "_unzipGradleDist", executor, (UnzipTask task) -> {
            task.zip.set((TaskIO<Path>)this.gradleWrapperDist);
            task.output.deriveFrom(this.projectDir, e -> e);
        });
        this.declareCompositeTask(zipTask);
    }

    public static GenerateGradleProjectTask create(String name, Executor executor, Consumer<GenerateGradleProjectTask> cons) {
        GenerateGradleProjectTask task = new GenerateGradleProjectTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Path projectDir = this.projectDir.get();
        Files.writeString(projectDir.resolve("build.gradle"), (CharSequence)this.buildGradleScript(this.javaVersion.get(), this.libraries.get()), new OpenOption[0]);
        Files.writeString(projectDir.resolve("settings.gradle"), (CharSequence)this.buildSettingsScript(), new OpenOption[0]);
        Files.writeString(projectDir.resolve(".gitignore"), (CharSequence)this.buildGitIgnore(), new OpenOption[0]);
        TestCaseDef testStats = null;
        Path testStatsFile = projectDir.resolve("src/main/resources/test_stats.json");
        if (Files.exists(testStatsFile, new LinkOption[0])) {
            testStats = TestCaseDef.loadTestStats(testStatsFile);
        }
        Files.writeString(projectDir.resolve("README.md"), (CharSequence)this.buildReadme(this.mcManifest.get(), this.gitRepoUrl.get(), testStats), new OpenOption[0]);
    }

    private String buildGradleScript(JavaVersion javaVersion, List<LibraryDownload> libraries) {
        StringWriter sw = new StringWriter();
        try (IndentPrintWriter pw = new IndentPrintWriter(new PrintWriter((Writer)sw, true));){
            pw.println("plugins {");
            pw.pushIndent();
            pw.println("id 'java'");
            pw.popIndent();
            pw.println("}");
            pw.println();
            pw.println("java {");
            pw.pushIndent();
            pw.println("toolchain {");
            pw.pushIndent();
            pw.println("languageVersion = JavaLanguageVersion.of(" + (javaVersion.ordinal() + 1) + ")");
            pw.popIndent();
            pw.println("}");
            pw.popIndent();
            pw.println("}");
            pw.println();
            pw.println("repositories {");
            pw.pushIndent();
            pw.println("mavenCentral()");
            pw.println("maven { url 'https://libraries.minecraft.net/' }");
            pw.popIndent();
            pw.println("}");
            pw.println();
            pw.println("dependencies {");
            pw.pushIndent();
            for (LibraryDownload library : libraries) {
                pw.println("implementation('" + String.valueOf(library.notation()) + "') { transitive = false }");
            }
            pw.popIndent();
            pw.println("}");
        }
        return sw.toString();
    }

    private String buildSettingsScript() {
        return "pluginManagement {\n    repositories {\n        mavenLocal()\n        gradlePluginPortal()\n    }\n}\n\nplugins {\n    id 'org.gradle.toolchains.foojay-resolver-convention' version '0.8.0'\n}\n\nrootProject.name = 'Minecraft Client'\n";
    }

    private String buildGitIgnore() {
        return "# exclude all\n/*\n\n# Include Important Folders\n!src/\n\n# Gradle stuff\n!gradle/\n!gradlew\n!gradlew.bat\n!build.gradle\n!settings.gradle\n\n# Include git important files\n!.gitignore\n\n# Other files.\n!README.md\n!decompile_report.txt\n";
    }

    private String buildReadme(VersionManifest mcManifest, String gitRepoUrl, @Nullable TestCaseDef testStats) {
        Object readme = "# Shoveled\nOutput of SnowShovel\n";
        if (testStats != null) {
            readme = (String)readme + new ReportTableGenerator().addRow(mcManifest.id(), testStats, gitRepoUrl, mcManifest.computeBranchName()).build();
        }
        return readme;
    }
}

