/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public record InMemoryDownload(boolean isUpToDate, byte[] body, @Nullable String etag) {
    @Nullable
    public static InMemoryDownload readFrom(Path file) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            return null;
        }
        Path etagFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".etag");
        return new InMemoryDownload(true, Files.readAllBytes(file), Files.exists(etagFile, new LinkOption[0]) ? Files.readString(etagFile, StandardCharsets.UTF_8) : null);
    }

    public void writeTo(Path file) throws IOException {
        Files.write(IOUtils.makeParents((Path)file), this.body, new OpenOption[0]);
        if (this.etag != null) {
            Files.writeString(file.resolveSibling(String.valueOf(file.getFileName()) + ".etag"), (CharSequence)this.etag, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public static InMemoryDownload doDownload(HttpEngine http, String url, @Nullable InMemoryDownload existing) {
        class DownloadDest
        implements DownloadAction.Dest {
            private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
            @Nullable
            private String etag;

            DownloadDest() {
            }

            public void reset() {
                this.bos.reset();
                this.etag = InMemoryDownload.this != null ? InMemoryDownload.this.etag : null;
            }

            public OutputStream getOutputStream() {
                return this.bos;
            }

            @Nullable
            public String getEtag() {
                return this.etag;
            }

            public void setEtag(String etag) {
                this.etag = etag;
            }

            public long getLastModified() {
                return -1L;
            }

            public void setLastModified(long time) {
            }

            public void onFinished(boolean success) {
            }
        }
        DownloadDest dest = existing.new DownloadDest();
        boolean isUpToDate = (Boolean)InMemoryDownload.getWithRetry(10, () -> {
            dest.reset();
            HttpEngineDownloadAction action = new HttpEngineDownloadAction(http).setUrl(url).setDest((DownloadAction.Dest)dest).setQuiet(false).setUseETag(true);
            action.execute();
            if (action.isUpToDate() && existing != null) {
                dest.bos.writeBytes(existing.body);
            }
            return action.isUpToDate();
        });
        return new InMemoryDownload(isUpToDate, dest.bos.toByteArray(), dest.etag);
    }

    private static <T> T getWithRetry(int retries, SneakyUtils.ThrowingSupplier<T, IOException> r) {
        if (retries == 0) {
            throw new IllegalArgumentException("Need more than 0 retries.");
        }
        Throwable throwable = null;
        for (int i = 0; i < retries; ++i) {
            try {
                return (T)r.get();
            }
            catch (Throwable ex) {
                if (throwable == null) {
                    throwable = ex;
                    continue;
                }
                throwable.addSuppressed(ex);
                continue;
            }
        }
        if (throwable == null) {
            throwable = new RuntimeException("Run failed?");
        }
        SneakyUtils.throwUnchecked(throwable);
        return null;
    }

    @Override
    public String toString() {
        return new String(this.body, StandardCharsets.UTF_8);
    }
}

