/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.JdkInstallationManager;
import net.covers1624.jdkutils.locator.JavaLocator;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumProvisioner;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.javasauce.ss.util.MemoizedSupplier;

public final class JdkProvider {
    private final JavaLocator locator = JavaLocator.builder().useJavaw().findGradleJdks().findIntellijJdks().ignoreOpenJ9().build();
    private final JdkInstallationManager installer;
    private final Supplier<List<JavaInstall>> installs;

    public JdkProvider(Path baseInstallDir, HttpEngine httpEngine) {
        this.installer = new JdkInstallationManager(baseInstallDir, (JdkInstallationManager.JdkProvisioner)new AdoptiumProvisioner(httpEngine));
        this.installs = new MemoizedSupplier<List>(() -> {
            try {
                return this.locator.findJavaVersions();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to find java versions.", ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path findOrProvisionJdk(JavaVersion version) {
        for (JavaInstall javaInstall : this.installs.get()) {
            if (!javaInstall.hasCompiler || javaInstall.langVersion != version) continue;
            return javaInstall.javaHome;
        }
        try {
            JdkInstallationManager jdkInstallationManager = this.installer;
            synchronized (jdkInstallationManager) {
                return this.installer.provisionJdk(new JdkInstallationManager.ProvisionRequest.Builder().forVersion(version).build());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to provision JDK.", ex);
        }
    }
}

