/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.maven.MavenNotation;
import net.javasauce.ss.util.VersionManifest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public record LibraryDownload(MavenNotation notation, String url, @Nullable String sha1, long size, Path path) {
    public static final List<VersionManifest.Library> ANNOTATIONS = List.of(new VersionManifest.Library(MavenNotation.parse((String)"org.jetbrains:annotations:26.0.1"), null, null, null, null, null), new VersionManifest.Library(MavenNotation.parse((String)"com.google.code.findbugs:jsr305:3.0.2"), null, null, null, null, null));

    public static List<LibraryDownload> getVersionLibraries(VersionManifest manifest, Path librariesDir) {
        return FastStream.of(manifest.libraries()).concat(ANNOTATIONS).map(e -> LibraryDownload.computeDownload(e, librariesDir)).filter(Objects::nonNull).toList();
    }

    @Nullable
    private static LibraryDownload computeDownload(VersionManifest.Library library, Path librariesDir) {
        if (!VersionManifest.Rule.apply(library.rules(), Set.of())) {
            return null;
        }
        if (!library.natives().isEmpty()) {
            return null;
        }
        Path libPath = library.name().toPath(librariesDir);
        if (library.url() != null || library.downloads() == null) {
            String url = library.url();
            if (url == null) {
                url = library.name().toURL("https://proxy-maven.covers1624.net/").toString();
            }
            return new LibraryDownload(library.name(), url, null, -1L, libPath);
        }
        VersionManifest.LibraryDownloads downloads = library.downloads();
        VersionManifest.LibraryArtifact artifact = downloads.artifact();
        if (artifact == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)artifact.url())) {
            return null;
        }
        return new LibraryDownload(library.name(), artifact.url(), artifact.sha1(), artifact.size(), libPath);
    }
}

